/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.QueryTaskExecutor;
import org.apache.ignite.internal.sql.engine.exec.rel.Inbox;
import org.apache.ignite.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite.internal.sql.engine.message.InboxCloseMessage;
import org.apache.ignite.internal.sql.engine.message.MessageService;
import org.apache.ignite.internal.sql.engine.message.QueryBatchAcknowledgeMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.sql.engine.metadata.FragmentDescription;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;

public class ExchangeServiceImpl
implements ExchangeService {
    private static final IgniteLogger LOG = Loggers.forClass(ExchangeServiceImpl.class);
    private static final SqlQueryMessagesFactory FACTORY = new SqlQueryMessagesFactory();
    private final ClusterNode localNode;
    private final QueryTaskExecutor taskExecutor;
    private final MailboxRegistry mailboxRegistry;
    private final MessageService msgSrvc;

    public ExchangeServiceImpl(ClusterNode localNode, QueryTaskExecutor taskExecutor, MailboxRegistry mailboxRegistry, MessageService msgSrvc) {
        this.localNode = localNode;
        this.taskExecutor = taskExecutor;
        this.mailboxRegistry = mailboxRegistry;
        this.msgSrvc = msgSrvc;
    }

    @Override
    public void start() {
        this.msgSrvc.register((n, m) -> this.onMessage(n, (InboxCloseMessage)m), (short)5);
        this.msgSrvc.register((n, m) -> this.onMessage(n, (QueryBatchAcknowledgeMessage)m), (short)4);
        this.msgSrvc.register((n, m) -> this.onMessage(n, (QueryBatchMessage)m), (short)3);
    }

    @Override
    public <RowT> void sendBatch(String nodeId, UUID qryId, long fragmentId, long exchangeId, int batchId, boolean last, List<RowT> rows) throws IgniteInternalCheckedException {
        this.msgSrvc.send(nodeId, FACTORY.queryBatchMessage().queryId(qryId).fragmentId(fragmentId).exchangeId(exchangeId).batchId(batchId).last(last).rows(Commons.cast(rows)).build());
    }

    @Override
    public void acknowledge(String nodeId, UUID qryId, long fragmentId, long exchangeId, int batchId) throws IgniteInternalCheckedException {
        this.msgSrvc.send(nodeId, FACTORY.queryBatchAcknowledgeMessage().queryId(qryId).fragmentId(fragmentId).exchangeId(exchangeId).batchId(batchId).build());
    }

    @Override
    public void closeQuery(String nodeId, UUID qryId) throws IgniteInternalCheckedException {
        this.msgSrvc.send(nodeId, FACTORY.queryCloseMessage().queryId(qryId).build());
    }

    @Override
    public void closeInbox(String nodeId, UUID qryId, long fragmentId, long exchangeId) throws IgniteInternalCheckedException {
        this.msgSrvc.send(nodeId, FACTORY.inboxCloseMessage().queryId(qryId).fragmentId(fragmentId).exchangeId(exchangeId).build());
    }

    @Override
    public void sendError(String nodeId, UUID qryId, long fragmentId, Throwable err) throws IgniteInternalCheckedException {
        this.msgSrvc.send(nodeId, FACTORY.errorMessage().queryId(qryId).fragmentId(fragmentId).error(err).build());
    }

    @Override
    public boolean alive(String nodeId) {
        return this.msgSrvc.alive(nodeId);
    }

    protected void onMessage(String nodeId, InboxCloseMessage msg) {
        Collection<Inbox<?>> inboxes = this.mailboxRegistry.inboxes(msg.queryId(), msg.fragmentId(), msg.exchangeId());
        if (!CollectionUtils.nullOrEmpty(inboxes)) {
            for (Inbox<?> inbox : inboxes) {
                inbox.context().execute(inbox::close, inbox::onError);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Stale inbox cancel message received [nodeId={}, queryId={}, fragmentId={}, exchangeId={}]", new Object[]{nodeId, msg.queryId(), msg.fragmentId(), msg.exchangeId()});
        }
    }

    protected void onMessage(String nodeId, QueryBatchAcknowledgeMessage msg) {
        Outbox<?> outbox = this.mailboxRegistry.outbox(msg.queryId(), msg.exchangeId());
        if (outbox != null) {
            try {
                outbox.onAcknowledge(nodeId, msg.batchId());
            }
            catch (Throwable e) {
                outbox.onError(e);
                throw new IgniteInternalException(ErrorGroups.Common.UNEXPECTED_ERR, "Unexpected exception", e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Stale acknowledge message received: [nodeId={}, queryId={}, fragmentId={}, exchangeId={}, batchId={}]", new Object[]{nodeId, msg.queryId(), msg.fragmentId(), msg.exchangeId(), msg.batchId()});
        }
    }

    protected void onMessage(String nodeId, QueryBatchMessage msg) {
        Inbox<?> inbox = this.mailboxRegistry.inbox(msg.queryId(), msg.exchangeId());
        if (inbox == null && msg.batchId() == 0) {
            Inbox newInbox = new Inbox(this.baseInboxContext(nodeId, msg.queryId(), msg.fragmentId()), this, this.mailboxRegistry, msg.exchangeId(), msg.exchangeId());
            inbox = this.mailboxRegistry.register(newInbox);
        }
        if (inbox != null) {
            try {
                inbox.onBatchReceived(nodeId, msg.batchId(), msg.last(), Commons.cast(msg.rows()));
            }
            catch (Throwable e) {
                inbox.onError(e);
                throw new IgniteInternalException(ErrorGroups.Common.UNEXPECTED_ERR, "Unexpected exception", e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Stale batch message received: [nodeId={}, queryId={}, fragmentId={}, exchangeId={}, batchId={}]", new Object[]{nodeId, msg.queryId(), msg.fragmentId(), msg.exchangeId(), msg.batchId()});
        }
    }

    private ExecutionContext<?> baseInboxContext(String nodeId, UUID qryId, long fragmentId) {
        return new ExecutionContext(BaseQueryContext.builder().logger(LOG).build(), this.taskExecutor, qryId, this.localNode, nodeId, new FragmentDescription(fragmentId, null, null, (Long2ObjectMap<List<String>>)Long2ObjectMaps.emptyMap()), null, Map.of(), null);
    }

    @Override
    public void stop() {
    }
}

