/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.prep;

import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.geom.prep.PreparedPolygonPredicate;
import org.locationtech.jts.noding.SegmentStringUtil;

class PreparedPolygonIntersects
extends PreparedPolygonPredicate {
    public static boolean intersects(PreparedPolygon prep, Geometry geom) {
        PreparedPolygonIntersects polyInt = new PreparedPolygonIntersects(prep);
        return polyInt.intersects(geom);
    }

    public PreparedPolygonIntersects(PreparedPolygon prepPoly) {
        super(prepPoly);
    }

    public boolean intersects(Geometry geom) {
        boolean isPrepGeomInArea;
        boolean segsIntersect;
        boolean isInPrepGeomArea = this.isAnyTestComponentInTarget(geom);
        if (isInPrepGeomArea) {
            return true;
        }
        if (geom.getDimension() == 0) {
            return false;
        }
        List lineSegStr = SegmentStringUtil.extractSegmentStrings(geom);
        if (lineSegStr.size() > 0 && (segsIntersect = this.prepPoly.getIntersectionFinder().intersects(lineSegStr))) {
            return true;
        }
        return geom.getDimension() == 2 && (isPrepGeomInArea = this.isAnyTargetComponentInAreaTest(geom, this.prepPoly.getRepresentativePoints()));
    }
}

