/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.TxStateReplicaRequest;
import org.apache.ignite.internal.tx.message.TxStateReplicaRequestBuilder;

public class TxStateReplicaRequestImpl
implements TxStateReplicaRequest {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private HybridTimestamp commitTimestamp;
    private byte[] commitTimestampByteArray;
    @IgniteToStringInclude
    private ReplicationGroupId groupId;
    private byte[] groupIdByteArray;
    @IgniteToStringInclude
    private UUID txId;
    private byte[] txIdByteArray;

    private TxStateReplicaRequestImpl(HybridTimestamp commitTimestamp, byte[] commitTimestampByteArray, ReplicationGroupId groupId, byte[] groupIdByteArray, UUID txId, byte[] txIdByteArray) {
        this.commitTimestamp = commitTimestamp;
        this.commitTimestampByteArray = commitTimestampByteArray;
        this.groupId = groupId;
        this.groupIdByteArray = groupIdByteArray;
        this.txId = txId;
        this.txIdByteArray = txIdByteArray;
    }

    byte[] commitTimestampByteArray() {
        return this.commitTimestampByteArray;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    byte[] groupIdByteArray() {
        return this.groupIdByteArray;
    }

    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    byte[] txIdByteArray() {
        return this.txIdByteArray;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxStateReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxStateReplicaRequestImpl otherMessage = (TxStateReplicaRequestImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.txId, otherMessage.txId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commitTimestamp, this.groupId, this.txId);
        return result;
    }

    public static TxStateReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject commitTimestampByteArraymo = marshaller.marshal((Object)this.commitTimestamp);
        usedDescriptors.addAll((IntCollection)commitTimestampByteArraymo.usedDescriptorIds());
        this.commitTimestampByteArray = commitTimestampByteArraymo.bytes();
        MarshalledObject groupIdByteArraymo = marshaller.marshal((Object)this.groupId);
        usedDescriptors.addAll((IntCollection)groupIdByteArraymo.usedDescriptorIds());
        this.groupIdByteArray = groupIdByteArraymo.bytes();
        MarshalledObject txIdByteArraymo = marshaller.marshal((Object)this.txId);
        usedDescriptors.addAll((IntCollection)txIdByteArraymo.usedDescriptorIds());
        this.txIdByteArray = txIdByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.commitTimestamp = (HybridTimestamp)marshaller.unmarshal(this.commitTimestampByteArray, descriptorsObj);
        this.commitTimestampByteArray = null;
        this.groupId = (ReplicationGroupId)marshaller.unmarshal(this.groupIdByteArray, descriptorsObj);
        this.groupIdByteArray = null;
        this.txId = (UUID)marshaller.unmarshal(this.txIdByteArray, descriptorsObj);
        this.txIdByteArray = null;
    }

    private static class Builder
    implements TxStateReplicaRequestBuilder {
        private HybridTimestamp commitTimestamp;
        private byte[] commitTimestampByteArray;
        private ReplicationGroupId groupId;
        private byte[] groupIdByteArray;
        private UUID txId;
        private byte[] txIdByteArray;

        private Builder() {
        }

        @Override
        public TxStateReplicaRequestBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public TxStateReplicaRequestBuilder commitTimestampByteArray(byte[] commitTimestampByteArray) {
            this.commitTimestampByteArray = commitTimestampByteArray;
            return this;
        }

        @Override
        public TxStateReplicaRequestBuilder groupId(ReplicationGroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public TxStateReplicaRequestBuilder groupIdByteArray(byte[] groupIdByteArray) {
            this.groupIdByteArray = groupIdByteArray;
            return this;
        }

        @Override
        public TxStateReplicaRequestBuilder txId(UUID txId) {
            this.txId = txId;
            return this;
        }

        @Override
        public TxStateReplicaRequestBuilder txIdByteArray(byte[] txIdByteArray) {
            this.txIdByteArray = txIdByteArray;
            return this;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public byte[] commitTimestampByteArray() {
            return this.commitTimestampByteArray;
        }

        @Override
        public ReplicationGroupId groupId() {
            return this.groupId;
        }

        @Override
        public byte[] groupIdByteArray() {
            return this.groupIdByteArray;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public byte[] txIdByteArray() {
            return this.txIdByteArray;
        }

        @Override
        public TxStateReplicaRequest build() {
            return new TxStateReplicaRequestImpl(this.commitTimestamp, this.commitTimestampByteArray, this.groupId, this.groupIdByteArray, this.txId, this.txIdByteArray);
        }
    }
}

