/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.argument.parser;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgumentParser;

public class CLIArgument<T> {
    private final BiConsumer<String, T> EMPTY = (name, val) -> {};
    private final String name;
    private final String usage;
    private final boolean isOptional;
    private final Class<T> type;
    private final Function<CLIArgumentParser, T> dfltValSupplier;
    private final BiConsumer<String, T> validator;

    public static <T> CLIArgument<T> optionalArg(String name, String usage, Class<T> type) {
        return new CLIArgument<T>(name, usage, true, type, null, null);
    }

    public static <T> CLIArgument<T> optionalArg(String name, String usage, Class<T> type, Supplier<T> dfltValSupplier) {
        return new CLIArgument<Object>(name, usage, true, type, p -> dfltValSupplier.get(), null);
    }

    public static <T> CLIArgument<T> optionalArg(String name, String usage, Class<T> type, Function<CLIArgumentParser, T> dfltValSupplier, BiConsumer<String, T> validator) {
        return new CLIArgument<T>(name, usage, true, type, dfltValSupplier, validator);
    }

    public static <T> CLIArgument<T> mandatoryArg(String name, String usage, Class<T> type) {
        return new CLIArgument<T>(name, usage, false, type, null, null);
    }

    public CLIArgument(String name2, String usage, boolean isOptional, Class<T> type, Function<CLIArgumentParser, T> dfltValSupplier, BiConsumer<String, T> validator) {
        this.name = name2;
        this.usage = usage;
        this.isOptional = isOptional;
        this.type = type;
        this.dfltValSupplier = dfltValSupplier == null ? (type.equals(Boolean.class) ? p -> Boolean.FALSE : p -> null) : dfltValSupplier;
        this.validator = validator;
    }

    public String name() {
        return this.name;
    }

    public String usage() {
        return this.usage;
    }

    public boolean optional() {
        return this.isOptional;
    }

    public Class<T> type() {
        return this.type;
    }

    public Function<CLIArgumentParser, T> defaultValueSupplier() {
        return this.dfltValSupplier;
    }

    public BiConsumer<String, T> validator() {
        return this.validator == null ? this.EMPTY : this.validator;
    }
}

