/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.sql.stat;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite.internal.util.typedef.F;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlStatisticsTable
extends SqlCall {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("StatisticsTable", SqlKind.OTHER);
    private final SqlIdentifier name;
    private final SqlNodeList columns;

    public IgniteSqlStatisticsTable(SqlIdentifier name, @Nullable SqlNodeList columns, SqlParserPos pos) {
        super(pos);
        this.name = name;
        this.columns = !F.isEmpty((Collection)columns) ? SqlNodeList.of((SqlParserPos)columns.getParserPosition(), (List)columns.getList()) : null;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name, (Object)this.columns);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new IgniteSqlStatisticsTable(this.name, this.columns, pos);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columns != null) {
            this.columns.unparse(writer, leftPrec, rightPrec);
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public List<SqlNode> columns() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SqlNode>(this.columns.getList());
    }
}

