/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexCount;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.rule.ImmutableIndexCountRule;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.immutables.value.Value;

@Value.Enclosing
public class IndexCountRule
extends RelRule<Config> {
    public static final IndexCountRule INSTANCE = Config.DEFAULT.toRule();

    private IndexCountRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate aggr = (LogicalAggregate)call.rel(0);
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)call.rel(1);
        IgniteTable table = (IgniteTable)scan.getTable().unwrap(IgniteTable.class);
        if (table.isIndexRebuildInProgress() || scan.condition() != null || aggr.getGroupCount() > 0 || aggr.getAggCallList().size() != 1) {
            return;
        }
        AggregateCall agg = (AggregateCall)aggr.getAggCallList().get(0);
        if (agg.getAggregation().getKind() != SqlKind.COUNT || agg.hasFilter() || agg.isDistinct()) {
            return;
        }
        List argList = agg.getArgList();
        IgniteIndex idx = null;
        boolean notNull = false;
        int fieldIdx = 0;
        if (argList.isEmpty()) {
            idx = table.getIndex("_key_PK");
        } else {
            if (scan.projects() != null || argList.size() > 1) {
                return;
            }
            notNull = true;
            fieldIdx = (Integer)argList.get(0);
            if (!scan.requiredColumns().isEmpty()) {
                fieldIdx = scan.requiredColumns().nth(fieldIdx);
            }
            for (IgniteIndex idx0 : table.indexes().values()) {
                List fieldCollations = idx0.collation().getFieldCollations();
                if (fieldCollations.isEmpty() || ((RelFieldCollation)fieldCollations.get(0)).getFieldIndex() != fieldIdx) continue;
                idx = idx0;
                break;
            }
        }
        if (idx == null) {
            return;
        }
        BaseQueryContext baseQryCtx = (BaseQueryContext)call.getPlanner().getContext().unwrap(BaseQueryContext.class);
        IgniteDistribution distribution = baseQryCtx.isLocal() ? IgniteDistributions.single() : (table.distribution().getType() == RelDistribution.Type.HASH_DISTRIBUTED ? IgniteDistributions.random() : table.distribution());
        RelTraitSet idxTraits = aggr.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)distribution).replace((RelTrait)RewindabilityTrait.REWINDABLE);
        IgniteIndexCount idxCnt = new IgniteIndexCount(scan.getCluster(), idxTraits, scan.getTable(), idx.name(), notNull, fieldIdx);
        RelBuilder b = call.builder();
        call.transformTo(b.push((RelNode)idxCnt).aggregate(b.groupKey(), Collections.nCopies(aggr.getAggCallList().size(), b.aggregateCall(SqlStdOperatorTable.SUM0, new RexNode[]{b.field(0)}))).project(Commons.transform(Ord.zip((List)b.fields()), f -> b.cast((RexNode)f.e, ((RelDataTypeField)aggr.getRowType().getFieldList().get(f.i)).getType().getSqlTypeName()))).build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableIndexCountRule.Config.of().withDescription("IndexCountRule").withOperandSupplier(r -> r.operand(LogicalAggregate.class).oneInput(i -> i.operand(IgniteLogicalTableScan.class).anyInputs()));

        default public IndexCountRule toRule() {
            return new IndexCountRule(this);
        }
    }
}

