/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeCondition;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;

public class TransformRangeIterable<FromRow, ToRow>
implements RangeIterable<ToRow> {
    private final RangeIterable<FromRow> delegate;
    private final Function<FromRow, ToRow> rowTransformer;

    public TransformRangeIterable(RangeIterable<FromRow> delegate, Function<FromRow, ToRow> rowTransformer) {
        this.delegate = delegate;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public Iterator<RangeCondition<ToRow>> iterator() {
        return F.iterator(this.delegate.iterator(), (IgniteClosure & Serializable)c -> new TransformRangeCondition(c, this.rowTransformer), (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]);
    }

    @Override
    public boolean multiBounds() {
        return this.delegate.multiBounds();
    }

    private static class TransformRangeCondition<FromRow, ToRow>
    implements RangeCondition<ToRow> {
        private final RangeCondition<FromRow> delegate;
        private final Function<FromRow, ToRow> rowTransformer;

        public TransformRangeCondition(RangeCondition<FromRow> delegate, Function<FromRow, ToRow> rowTransformer) {
            this.delegate = delegate;
            this.rowTransformer = rowTransformer;
        }

        @Override
        public ToRow lower() {
            FromRow row = this.delegate.lower();
            return row == null ? null : (ToRow)this.rowTransformer.apply(row);
        }

        @Override
        public ToRow upper() {
            FromRow row = this.delegate.upper();
            return row == null ? null : (ToRow)this.rowTransformer.apply(row);
        }

        @Override
        public boolean lowerInclude() {
            return this.delegate.lowerInclude();
        }

        @Override
        public boolean upperInclude() {
            return this.delegate.upperInclude();
        }
    }
}

