/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.ignite.internal.processors.query.calcite.util.IgniteMath;
import org.jetbrains.annotations.Nullable;

public class IgniteExpressions {
    public static Expression makeBinary(ExpressionType binaryType, Expression left, Expression right) {
        switch (binaryType) {
            case Add: {
                return IgniteExpressions.addExact(left, right);
            }
            case Subtract: {
                return IgniteExpressions.subtractExact(left, right);
            }
            case Multiply: {
                return IgniteExpressions.multiplyExact(left, right);
            }
            case Divide: {
                return IgniteExpressions.divideExact(left, right);
            }
        }
        return Expressions.makeBinary((ExpressionType)binaryType, (Expression)left, (Expression)right);
    }

    public static Expression makeUnary(ExpressionType unaryType, Expression operand) {
        switch (unaryType) {
            case Negate: 
            case NegateChecked: {
                return IgniteExpressions.negateExact(unaryType, operand);
            }
        }
        return Expressions.makeUnary((ExpressionType)unaryType, (Expression)operand);
    }

    public static Expression addExact(Expression left, Expression right) {
        if (IgniteExpressions.larger(left.getType(), right.getType()).isFixedNumeric()) {
            return Expressions.call(IgniteMath.class, (String)"addExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Add, (Expression)left, (Expression)right);
    }

    public static Expression subtractExact(Expression left, Expression right) {
        if (IgniteExpressions.larger(left.getType(), right.getType()).isFixedNumeric()) {
            return Expressions.call(IgniteMath.class, (String)"subtractExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Subtract, (Expression)left, (Expression)right);
    }

    public static Expression multiplyExact(Expression left, Expression right) {
        if (IgniteExpressions.larger(left.getType(), right.getType()).isFixedNumeric()) {
            return Expressions.call(IgniteMath.class, (String)"multiplyExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Multiply, (Expression)left, (Expression)right);
    }

    public static Expression divideExact(Expression left, Expression right) {
        if (IgniteExpressions.larger(left.getType(), right.getType()).isFixedNumeric()) {
            return Expressions.call(IgniteMath.class, (String)"divideExact", (Expression[])new Expression[]{left, right});
        }
        return Expressions.makeBinary((ExpressionType)ExpressionType.Divide, (Expression)left, (Expression)right);
    }

    private static Expression negateExact(ExpressionType unaryType, Expression operand) {
        assert (unaryType == ExpressionType.Negate || unaryType == ExpressionType.NegateChecked);
        Type opType = operand.getType();
        if (opType == Integer.TYPE || opType == Long.TYPE || opType == Short.TYPE || opType == Byte.TYPE) {
            return Expressions.call(IgniteMath.class, (String)"negateExact", (Expression[])new Expression[]{operand});
        }
        return Expressions.makeUnary((ExpressionType)unaryType, (Expression)operand);
    }

    public static Expression convertChecked(Expression exp, Primitive fromPrimitive, Primitive toPrimitive) {
        if (fromPrimitive.ordinal() <= toPrimitive.ordinal() || !toPrimitive.isFixedNumeric()) {
            return Expressions.convert_((Expression)exp, (Type)toPrimitive.primitiveClass);
        }
        return Expressions.call(IgniteMath.class, (String)("convertTo" + SqlFunctions.initcap((String)toPrimitive.primitiveName) + "Exact"), (Expression[])new Expression[]{exp});
    }

    public static Expression parseStringChecked(Expression exp, Primitive toPrimitive) {
        return Expressions.call(IgniteMath.class, (String)("convertTo" + SqlFunctions.initcap((String)toPrimitive.primitiveName) + "Exact"), (Expression[])new Expression[]{Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{exp})});
    }

    public static Expression unboxChecked(Expression exp, @Nullable Primitive fromBox, Primitive toPrimitive) {
        if (fromBox != null && fromBox.ordinal() <= toPrimitive.ordinal() || !toPrimitive.isFixedNumeric()) {
            return Expressions.unbox((Expression)exp, (Primitive)toPrimitive);
        }
        return Expressions.call(IgniteMath.class, (String)("convertTo" + SqlFunctions.initcap((String)toPrimitive.primitiveName) + "Exact"), (Expression[])new Expression[]{exp});
    }

    private static Primitive larger(Type type0, Type type1) {
        Primitive primitive0 = Primitive.ofBoxOr((Type)type0);
        Primitive primitive1 = Primitive.ofBoxOr((Type)type1);
        return primitive0.ordinal() > primitive1.ordinal() ? primitive0 : primitive1;
    }
}

