/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.jetbrains.annotations.Nullable;

public class SortedListRangeCursor<Row>
implements GridCursor<Row> {
    private final Comparator<Row> comp;
    private final List<Row> rows;
    private final Row upper;
    private final boolean includeUpper;
    private Row row;
    private int idx;

    public SortedListRangeCursor(Comparator<Row> comp, List<Row> rows, @Nullable Row lower, @Nullable Row upper, boolean lowerInclude, boolean upperInclude) {
        this.comp = comp;
        this.rows = rows;
        this.upper = upper;
        this.includeUpper = upperInclude;
        this.idx = lower == null ? 0 : this.lowerBound(rows, lower, lowerInclude);
    }

    private int lowerBound(List<Row> rows, Row bound, boolean includeBound) {
        int low = 0;
        int high = rows.size() - 1;
        int idx = -1;
        while (low <= high) {
            int mid = (high - low) / 2 + low;
            int compRes = this.comp.compare(rows.get(mid), bound);
            if (compRes > 0) {
                high = mid - 1;
                continue;
            }
            if (compRes == 0 && includeBound) {
                idx = mid;
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return idx == -1 ? low : idx;
    }

    public boolean next() {
        if (this.idx == this.rows.size() || this.upper != null && -this.comp.compare(this.rows.get(this.idx), this.upper) < (this.includeUpper ? 0 : 1)) {
            return false;
        }
        this.row = this.rows.get(this.idx++);
        return true;
    }

    public Row get() {
        return this.row;
    }
}

