/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.IndexScan;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.jetbrains.annotations.Nullable;

public class IndexFirstLastScan<Row>
extends IndexScan<Row> {
    private final boolean first;

    public IndexFirstLastScan(boolean first, ExecutionContext<Row> ectx, CacheTableDescriptor desc, InlineIndexImpl idx, ImmutableIntList idxFieldMapping, int[] parts, @Nullable ImmutableBitSet requiredColumns) {
        super(ectx, desc, (InlineIndex)idx, idxFieldMapping, parts, null, requiredColumns);
        this.first = first;
    }

    @Override
    protected TreeIndex<IndexRow> treeIndex() {
        return new FirstLastIndexWrapper(this.idx, this.indexQueryContext(), this.first);
    }

    @Override
    protected IndexQueryContext indexQueryContext() {
        IndexQueryContext res = super.indexQueryContext();
        return new IndexQueryContext(res.cacheFilter(), IndexFirstLastScan.createNotNullRowFilter(this.idx, true));
    }

    private static class FirstLastIndexWrapper
    extends IndexScan.TreeIndexWrapper {
        private final boolean first;

        protected FirstLastIndexWrapper(InlineIndex idx, IndexQueryContext qctx, boolean first) {
            super(idx, qctx);
            this.first = first;
        }

        @Override
        public GridCursor<IndexRow> find(IndexRow lower, IndexRow upper, boolean lowerInclude, boolean upperInclude) {
            assert (lower == null && upper == null);
            assert (lowerInclude && upperInclude);
            try {
                return this.idx.findFirstOrLast(this.qctx, this.first);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to take " + (this.first ? "first" : "last") + " not-null index value.", (Throwable)e);
            }
        }
    }
}

