/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.UUID;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.running.TrackableQuery;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class H2DmlInfo
implements TrackableQuery {
    private final long beginTs;
    private final long qryId;
    private final UUID initNodeId;
    private final String schema;
    private final String sql;

    public H2DmlInfo(long beginTs, long qryId, UUID initNodeId, String schema, String sql) {
        this.beginTs = beginTs;
        this.qryId = qryId;
        this.initNodeId = initNodeId;
        this.schema = schema;
        this.sql = sql;
    }

    public long time() {
        return U.currentTimeMillis() - this.beginTs;
    }

    public String queryInfo(@Nullable String additionalInfo) {
        StringBuilder msgSb = new StringBuilder();
        if (this.qryId == 0L) {
            msgSb.append(" [globalQueryId=(undefined), node=").append(this.initNodeId);
        } else {
            msgSb.append(" [globalQueryId=").append(QueryUtils.globalQueryId((UUID)this.initNodeId, (long)this.qryId));
        }
        if (additionalInfo != null) {
            msgSb.append(", ").append(additionalInfo);
        }
        msgSb.append(", duration=").append(this.time()).append("ms").append(", type=DML").append(", schema=").append(this.schema).append(", sql='").append(this.sql).append("']");
        return msgSb.toString();
    }
}

