/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlStaticAggFunction;
import org.apache.calcite.sql.fun.SqlAbstractGroupFunction;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

class SqlGroupingFunction
extends SqlAbstractGroupFunction {
    private static final SqlStaticAggFunction STATIC = SqlGroupingFunction::constant;

    SqlGroupingFunction(String name) {
        super(name, SqlKind.GROUPING, ReturnTypes.BIGINT, null, OperandTypes.ONE_OR_MORE, SqlFunctionCategory.SYSTEM);
    }

    private static @Nullable RexNode constant(RexBuilder rexBuilder, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, AggregateCall aggregateCall) {
        ImmutableBitSet argSet = ImmutableBitSet.of(aggregateCall.getArgList());
        if (groupSets.stream().allMatch(set -> set.contains(argSet))) {
            return rexBuilder.makeExactLiteral(BigDecimal.ZERO);
        }
        return null;
    }

    @Override
    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz.isInstance(STATIC)) {
            return clazz.cast(STATIC);
        }
        return super.unwrap(clazz);
    }
}

