/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.base.Preconditions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexFieldAccess
extends RexNode {
    private final RexNode expr;
    private final RelDataTypeField field;

    RexFieldAccess(RexNode expr, RelDataTypeField field) {
        RexFieldAccess.checkValid(expr, field);
        this.expr = expr;
        this.field = field;
        this.digest = expr + "." + field.getName();
    }

    private static void checkValid(RexNode expr, RelDataTypeField field) {
        RelDataType exprType = expr.getType();
        int fieldIdx = field.getIndex();
        Preconditions.checkArgument((fieldIdx >= 0 && fieldIdx < exprType.getFieldList().size() && exprType.getFieldList().get(fieldIdx).equals(field) ? 1 : 0) != 0, (String)"Field %s does not exist for expression %s", (Object)field, (Object)expr);
    }

    public RelDataTypeField getField() {
        return this.field;
    }

    @Override
    public RelDataType getType() {
        return this.field.getType();
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.FIELD_ACCESS;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitFieldAccess(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitFieldAccess(this, arg);
    }

    public RexNode getReferenceExpr() {
        return this.expr;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RexFieldAccess that = (RexFieldAccess)o;
        return this.field.equals(that.field) && this.expr.equals(that.expr);
    }

    @Override
    public int hashCode() {
        int result = this.expr.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }
}

