/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.metric.jmx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricManager;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.spi.metric.jmx.MetricRegistryMBean;
import org.jetbrains.annotations.Nullable;

public class JmxMetricExporterSpi
extends IgniteSpiAdapter
implements MetricExporterSpi {
    private ReadOnlyMetricManager mreg;
    @Nullable
    private Predicate<ReadOnlyMetricRegistry> filter;
    private final List<ObjectName> mBeans = Collections.synchronizedList(new ArrayList());

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.mreg.forEach(this::register);
        this.mreg.addMetricRegistryCreationListener(this::register);
        this.mreg.addMetricRegistryRemoveListener(this::unregister);
    }

    private void register(ReadOnlyMetricRegistry mreg) {
        if (this.filter != null && !this.filter.test(mreg)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Metric registry filtered and will not be registered.[registry=" + mreg.name() + "]");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found new metric registry [name=" + mreg.name() + "]");
        }
        MetricName n = this.parse(mreg.name());
        try {
            MetricRegistryMBean mregBean = new MetricRegistryMBean(mreg);
            ObjectName mbean = U.registerMBean(this.ignite().configuration().getMBeanServer(), this.igniteInstanceName, n.root(), n.subName(), mregBean, MetricRegistryMBean.class);
            this.mBeans.add(mbean);
            if (this.log.isDebugEnabled()) {
                this.log.debug("MetricGroup JMX bean created. " + mbean);
            }
        }
        catch (JMException e) {
            this.log.error("MBean for metric registry '" + mreg.name() + "' can't be created.", e);
        }
    }

    private void unregister(ReadOnlyMetricRegistry mreg) {
        if (this.filter != null && !this.filter.test(mreg)) {
            return;
        }
        MetricName n = this.parse(mreg.name());
        try {
            ObjectName mbeanName = IgniteUtils.makeMBeanName(this.igniteInstanceName, n.root(), n.subName());
            boolean rmv = this.mBeans.remove(mbeanName);
            assert (rmv);
            this.unregBean(this.ignite, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            this.log.error("MBean for metric registry '" + n.root() + "," + n.subName() + "' can't be unregistered.", e);
        }
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        Ignite ignite = this.ignite();
        if (ignite == null) {
            return;
        }
        for (ObjectName bean : this.mBeans) {
            this.unregBean(ignite, bean);
        }
    }

    private void unregBean(Ignite ignite, ObjectName bean) {
        MBeanServer jmx = ignite.configuration().getMBeanServer();
        try {
            jmx.unregisterMBean(bean);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered SPI MBean: " + bean);
            }
        }
        catch (JMException e) {
            this.log.error("Failed to unregister SPI MBean: " + bean, e);
        }
    }

    @Override
    public void setMetricRegistry(ReadOnlyMetricManager reg) {
        this.mreg = reg;
    }

    @Override
    public void setExportFilter(Predicate<ReadOnlyMetricRegistry> filter) {
        this.filter = filter;
    }

    private MetricName parse(String regName) {
        int firstDot = regName.indexOf(46);
        if (firstDot == -1) {
            return new MetricName(null, regName);
        }
        String grp = regName.substring(0, firstDot);
        String beanName = regName.substring(firstDot + 1);
        return new MetricName(grp, beanName);
    }

    private class MetricName {
        private String root;
        private String subName;

        MetricName(String root, String subName) {
            this.root = root;
            this.subName = subName;
        }

        public String root() {
            return this.root;
        }

        public String subName() {
            return this.subName;
        }
    }
}

