/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.beforeStart;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.request.GridRestNodeStateBeforeStartRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestWarmUpRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class NodeStateBeforeStartCommandHandler
extends GridRestCommandHandlerAdapter {
    public NodeStateBeforeStartCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return Arrays.asList(GridRestCommand.NODE_STATE_BEFORE_START, GridRestCommand.WARM_UP);
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        GridRestNodeStateBeforeStartRequest restReq = (GridRestNodeStateBeforeStartRequest)req;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling REST request: " + req);
        }
        try {
            GridRestWarmUpRequest warmUpReq;
            if (restReq instanceof GridRestWarmUpRequest && (warmUpReq = (GridRestWarmUpRequest)restReq).stopWarmUp()) {
                this.ctx.cache().stopWarmUp();
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to execute cache command: " + req, e);
            return new GridFinishedFuture<GridRestResponse>(e);
        }
        return new GridFinishedFuture<GridRestResponse>(new GridRestResponse());
    }
}

