/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.cache.CacheException;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.internal.processors.cache.query.QueryEntityClassProperty;
import org.apache.ignite.internal.processors.cache.query.QueryEntityIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class QueryEntityTypeDescriptor {
    @GridToStringInclude
    private final Map<String, Class<?>> fields = new LinkedHashMap();
    @GridToStringExclude
    private final Map<String, QueryEntityClassProperty> props = new LinkedHashMap<String, QueryEntityClassProperty>();
    @GridToStringInclude
    private final Set<String> keyProps = new HashSet<String>();
    @GridToStringInclude
    private final Map<String, QueryEntityIndexDescriptor> indexes = new HashMap<String, QueryEntityIndexDescriptor>();
    private Set<String> notNullFields = new HashSet<String>();
    private Map<String, Integer> fieldsPrecision = new HashMap<String, Integer>();
    private Map<String, Integer> fieldsScale = new HashMap<String, Integer>();
    private QueryEntityIndexDescriptor fullTextIdx;
    private final Class<?> keyCls;
    private final Class<?> valCls;
    private boolean valTextIdx;

    public QueryEntityTypeDescriptor(@NotNull Class<?> keyCls, @NotNull Class<?> valCls) {
        this.keyCls = keyCls;
        this.valCls = valCls;
    }

    public Map<String, GridQueryIndexDescriptor> indexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    public QueryEntityIndexDescriptor addIndex(String idxName, QueryIndexType type, int inlineSize) {
        if (inlineSize < 0 && inlineSize != -1) {
            throw new CacheException("Illegal inline size [idxName=" + idxName + ", inlineSize=" + inlineSize + "]");
        }
        QueryEntityIndexDescriptor idx = new QueryEntityIndexDescriptor(type, inlineSize);
        if (this.indexes.put(idxName, idx) != null) {
            throw new CacheException("Index with name '" + idxName + "' already exists.");
        }
        return idx;
    }

    public void addFieldToIndex(String idxName, String field, int orderNum, boolean descending) {
        QueryEntityIndexDescriptor desc = this.indexes.get(idxName);
        if (desc == null) {
            desc = this.addIndex(idxName, QueryIndexType.SORTED, -1);
        }
        desc.addField(field, orderNum, descending);
    }

    public void addFieldToTextIndex(String field) {
        if (this.fullTextIdx == null) {
            this.fullTextIdx = new QueryEntityIndexDescriptor(QueryIndexType.FULLTEXT);
            this.indexes.put(null, this.fullTextIdx);
        }
        this.fullTextIdx.addField(field, 0, false);
    }

    public Class<?> valueClass() {
        return this.valCls;
    }

    public Class<?> keyClass() {
        return this.keyCls;
    }

    public void addProperty(QueryEntityClassProperty prop, QuerySqlField sqlAnn, boolean key, boolean failOnDuplicate) {
        String propName = prop.name();
        if (sqlAnn != null && !F.isEmpty(sqlAnn.name())) {
            propName = sqlAnn.name();
        }
        if (this.props.put(propName, prop) != null && failOnDuplicate) {
            throw new CacheException("Property with name '" + propName + "' already exists for " + (key ? "key" : "value") + ": QueryEntity [key=" + this.keyCls.getName() + ", value=" + this.valCls.getName() + "]");
        }
        this.fields.put(prop.fullName(), prop.type());
        if (key) {
            this.keyProps.add(prop.fullName());
        }
    }

    public void addNotNullField(String field) {
        this.notNullFields.add(field);
    }

    public void addPrecision(String field, Integer precision) {
        this.fieldsPrecision.put(field, precision);
    }

    public void addScale(String field, int scale) {
        this.fieldsScale.put(field, scale);
    }

    public Set<String> notNullFields() {
        return this.notNullFields;
    }

    public Map<String, Integer> fieldsPrecision() {
        return this.fieldsPrecision;
    }

    public Map<String, Integer> fieldsScale() {
        return this.fieldsScale;
    }

    public Map<String, QueryEntityClassProperty> properties() {
        return this.props;
    }

    public Set<String> keyProperties() {
        return this.keyProps;
    }

    public boolean valueTextIndex() {
        return this.valTextIdx;
    }

    public void valueTextIndex(boolean valTextIdx) {
        this.valTextIdx = valTextIdx;
    }

    public String toString() {
        return S.toString(QueryEntityTypeDescriptor.class, this);
    }
}

