/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.FilteredRecord;
import org.apache.ignite.internal.pagemem.wal.record.LazyDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.UnwrapDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.WalSegmentTailReachedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StrictBoundsCheckException;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.SegmentHeader;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StandaloneWalRecordsIterator
extends AbstractWalRecordsIterator {
    public static final int DFLT_BUF_SIZE = 0x200000;
    private static final long serialVersionUID = 0L;
    private static final SegmentFileInputFactory FILE_INPUT_FACTORY = new SimpleSegmentFileInputFactory();
    @Nullable
    private final List<FileDescriptor> walFileDescriptors;
    private int curIdx = -1;
    private boolean keepBinary;
    private final WALPointer lowBound;
    private final WALRecord filteredRecord = new FilteredRecord();

    StandaloneWalRecordsIterator(@NotNull IgniteLogger log, @NotNull GridCacheSharedContext sharedCtx, @NotNull FileIOFactory ioFactory, @NotNull List<FileDescriptor> walFiles, IgniteBiPredicate<WALRecord.RecordType, WALPointer> readTypeFilter, WALPointer lowBound, WALPointer highBound, boolean keepBinary, int initialReadBufferSize, boolean strictBoundsCheck) throws IgniteCheckedException {
        super(log, sharedCtx, new RecordSerializerFactoryImpl(sharedCtx, readTypeFilter), ioFactory, initialReadBufferSize, highBound, FILE_INPUT_FACTORY);
        if (strictBoundsCheck) {
            StandaloneWalRecordsIterator.strictCheck(walFiles, lowBound, highBound);
        }
        this.lowBound = lowBound;
        this.keepBinary = keepBinary;
        this.walFileDescriptors = walFiles;
        this.init(walFiles);
        this.advance();
    }

    private static String printIndexes(List<FileDescriptor> walFiles) {
        return "[" + String.join((CharSequence)",", walFiles.stream().map(f -> Long.toString(f.idx())).collect(Collectors.toList())) + "]";
    }

    private static void strictCheck(List<FileDescriptor> walFiles, WALPointer lowBound, WALPointer highBound) throws IgniteCheckedException {
        long curWalSegmIdx;
        int idx;
        if (lowBound.index() > Long.MIN_VALUE) {
            for (idx = 0; idx < walFiles.size(); ++idx) {
                FileDescriptor desc = walFiles.get(idx);
                assert (desc != null);
                if (desc.idx() == lowBound.index()) break;
            }
        }
        if (idx == walFiles.size()) {
            throw new StrictBoundsCheckException("Wal segments not in bounds. loBoundIndex=" + lowBound.index() + ", indexes=" + StandaloneWalRecordsIterator.printIndexes(walFiles));
        }
        for (curWalSegmIdx = walFiles.get(idx).idx(); idx < walFiles.size() && curWalSegmIdx <= highBound.index(); ++idx, ++curWalSegmIdx) {
            FileDescriptor desc = walFiles.get(idx);
            assert (desc != null);
            if (curWalSegmIdx == desc.idx()) continue;
            throw new StrictBoundsCheckException("Wal segment " + curWalSegmIdx + " not found in files " + StandaloneWalRecordsIterator.printIndexes(walFiles));
        }
        if (highBound.index() < Long.MAX_VALUE && curWalSegmIdx <= highBound.index()) {
            throw new StrictBoundsCheckException("Wal segments not in bounds. hiBoundIndex=" + highBound.index() + ", indexes=" + StandaloneWalRecordsIterator.printIndexes(walFiles));
        }
    }

    private void init(List<FileDescriptor> walFiles) {
        if (walFiles == null || walFiles.isEmpty()) {
            return;
        }
        this.curWalSegmIdx = walFiles.get(this.curIdx + 1).idx() - 1L;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initialized WAL cursor [curWalSegmIdx=" + this.curWalSegmIdx + "]");
        }
    }

    @Override
    protected IgniteCheckedException validateTailReachedException(WalSegmentTailReachedException tailReachedException, AbstractWalRecordsIterator.AbstractReadFileHandle currWalSegment) {
        FileDescriptor lastWALSegmentDesc = this.walFileDescriptors.get(this.walFileDescriptors.size() - 1);
        assert (lastWALSegmentDesc != null);
        return lastWALSegmentDesc.idx() != currWalSegment.idx() ? new IgniteCheckedException("WAL tail reached not in the last available segment, potentially corrupted segment, last available segment idx=" + lastWALSegmentDesc.idx() + ", path=" + lastWALSegmentDesc.file().getPath() + ", last read segment idx=" + currWalSegment.idx(), tailReachedException) : null;
    }

    @Override
    protected AbstractWalRecordsIterator.AbstractReadFileHandle advanceSegment(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
        FileDescriptor fd;
        if (curWalSegment != null) {
            curWalSegment.close();
        }
        do {
            ++this.curWalSegmIdx;
            ++this.curIdx;
            if (this.curIdx < this.walFileDescriptors.size()) continue;
            return null;
        } while (!this.checkBounds((fd = this.walFileDescriptors.get(this.curIdx)).idx()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reading next file [absIdx=" + this.curWalSegmIdx + ", file=" + fd.file().getAbsolutePath() + "]");
        }
        assert (fd != null);
        this.curRec = null;
        try {
            WALPointer initPtr = null;
            if (this.lowBound.index() == fd.idx()) {
                initPtr = this.lowBound;
            }
            return this.initReadHandle(fd, initPtr);
        }
        catch (FileNotFoundException e) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Missing WAL segment in the archive: " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    protected IgniteBiTuple<WALPointer, WALRecord> advanceRecord(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle hnd) throws IgniteCheckedException {
        IgniteBiTuple<WALPointer, WALRecord> tup = super.advanceRecord(hnd);
        if (tup == null) {
            return tup;
        }
        if (!this.checkBounds(tup.get1())) {
            return new T2<WALPointer, WALRecord>(tup.get1(), this.filteredRecord);
        }
        return tup;
    }

    private boolean checkBounds(WALPointer ptr) {
        return ptr.compareTo(this.lowBound) >= 0 && ptr.compareTo(this.highBound) <= 0;
    }

    private boolean checkBounds(long idx) {
        return idx >= this.lowBound.index() && idx <= this.highBound.index();
    }

    @Override
    protected AbstractWalRecordsIterator.AbstractReadFileHandle initReadHandle(@NotNull AbstractWalRecordsIterator.AbstractFileDescriptor desc, @Nullable WALPointer start) throws IgniteCheckedException, FileNotFoundException {
        SegmentHeader segmentHdr;
        AbstractWalRecordsIterator.AbstractFileDescriptor fd = desc;
        SegmentIO fileIO = null;
        while (true) {
            try {
                fileIO = fd.toReadOnlyIO(this.ioFactory);
                segmentHdr = RecordV1Serializer.readSegmentHeader(fileIO, FILE_INPUT_FACTORY);
            }
            catch (IOException | IgniteCheckedException e) {
                this.log.error("Failed to init segment curWalSegmIdx=" + this.curWalSegmIdx + ", curIdx=" + this.curIdx, e);
                U.closeQuiet(fileIO);
                ++this.curIdx;
                if (this.curIdx >= this.walFileDescriptors.size()) {
                    return null;
                }
                fd = this.walFileDescriptors.get(this.curIdx);
                continue;
            }
            break;
        }
        return this.initReadHandle(fd, start, fileIO, segmentHdr);
    }

    @Override
    @NotNull
    protected WALRecord postProcessRecord(@NotNull WALRecord rec) {
        GridKernalContext kernalCtx = this.sharedCtx.kernalContext();
        IgniteCacheObjectProcessor proc = kernalCtx.cacheObjects();
        if (proc != null && (rec.type() == WALRecord.RecordType.DATA_RECORD || rec.type() == WALRecord.RecordType.DATA_RECORD_V2 || rec.type() == WALRecord.RecordType.CDC_DATA_RECORD)) {
            try {
                return this.postProcessDataRecord((DataRecord)rec, kernalCtx, proc);
            }
            catch (Exception e) {
                this.log.error("Failed to perform post processing for data record ", e);
            }
        }
        return super.postProcessRecord(rec);
    }

    @Override
    protected IgniteCheckedException handleRecordException(@NotNull Exception e, @Nullable WALPointer ptr) {
        if (e instanceof IgniteCheckedException && X.hasCause((Throwable)e, IgniteDataIntegrityViolationException.class) && this.curIdx == this.walFileDescriptors.size() - 1 && this.highBound.equals(IgniteWalIteratorFactory.IteratorParametersBuilder.DFLT_HIGH_BOUND)) {
            return null;
        }
        return super.handleRecordException(e, ptr);
    }

    @NotNull
    private WALRecord postProcessDataRecord(@NotNull DataRecord dataRec, GridKernalContext kernalCtx, IgniteCacheObjectProcessor processor) throws IgniteCheckedException {
        CacheObjectContext fakeCacheObjCtx = new CacheObjectContext(kernalCtx, null, null, false, false, false, false, false);
        int entryCnt = dataRec.entryCount();
        ArrayList<DataEntry> postProcessedEntries = new ArrayList<DataEntry>(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            DataEntry postProcessedEntry = this.postProcessDataEntry(processor, fakeCacheObjCtx, dataRec.get(i));
            postProcessedEntries.add(postProcessedEntry);
        }
        DataRecord res = new DataRecord(postProcessedEntries, dataRec.timestamp());
        res.size(dataRec.size());
        res.position(dataRec.position());
        return res;
    }

    @NotNull
    private DataEntry postProcessDataEntry(IgniteCacheObjectProcessor processor, CacheObjectContext fakeCacheObjCtx, DataEntry dataEntry) throws IgniteCheckedException {
        CacheObject val;
        KeyCacheObject key;
        boolean keepBinary;
        if (dataEntry instanceof RecordDataV1Serializer.EncryptedDataEntry) {
            return dataEntry;
        }
        boolean bl = keepBinary = this.keepBinary || !fakeCacheObjCtx.kernalContext().marshallerContext().initialized();
        if (dataEntry instanceof LazyDataEntry) {
            LazyDataEntry lazyDataEntry = (LazyDataEntry)dataEntry;
            key = processor.toKeyCacheObject(fakeCacheObjCtx, lazyDataEntry.getKeyType(), lazyDataEntry.getKeyBytes());
            byte type = lazyDataEntry.getValType();
            val = type == 0 ? null : processor.toCacheObject(fakeCacheObjCtx, type, lazyDataEntry.getValBytes());
        } else {
            key = dataEntry.key();
            val = dataEntry.value();
        }
        return this.unwrapDataEntry(fakeCacheObjCtx, dataEntry, key, val, keepBinary);
    }

    private DataEntry unwrapDataEntry(CacheObjectContext coCtx, DataEntry dataEntry, KeyCacheObject key, CacheObject val, boolean keepBinary) {
        return new UnwrapDataEntry(dataEntry.cacheId(), key, val, dataEntry.op(), dataEntry.nearXidVersion(), dataEntry.writeVersion(), dataEntry.expireTime(), dataEntry.partitionId(), dataEntry.partitionCounter(), coCtx, keepBinary, dataEntry.flags());
    }

    @Override
    protected void onClose() throws IgniteCheckedException {
        super.onClose();
        this.curRec = null;
        this.closeCurrentWalSegment();
        this.curWalSegmIdx = Integer.MAX_VALUE;
    }

    @Override
    protected AbstractWalRecordsIterator.AbstractReadFileHandle createReadFileHandle(SegmentIO fileIO, RecordSerializer ser, FileInput in) {
        return new FileWriteAheadLogManager.ReadFileHandle(fileIO, ser, in, null);
    }
}

