/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotMessage;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class SnapshotFilesRequestMessage
extends AbstractSnapshotMessage {
    public static final short TYPE_CODE = 178;
    private static final long serialVersionUID = 0L;
    private UUID reqId;
    private String snpName;
    private String snpPath;
    @GridDirectMap(keyType=Integer.class, valueType=int[].class)
    private Map<Integer, int[]> parts;

    public SnapshotFilesRequestMessage() {
    }

    public SnapshotFilesRequestMessage(String msgId, UUID reqId, String snpName, @Nullable String snpPath, Map<Integer, Set<Integer>> parts) {
        super(msgId);
        assert (parts != null && !parts.isEmpty());
        this.reqId = reqId;
        this.snpName = snpName;
        this.snpPath = snpPath;
        this.parts = new HashMap<Integer, int[]>();
        for (Map.Entry<Integer, Set<Integer>> e2 : F.view(parts.entrySet(), e -> !F.isEmpty((Collection)e.getValue()))) {
            this.parts.put(e2.getKey(), U.toIntArray((Collection<Integer>)e2.getValue()));
        }
    }

    public Map<Integer, Set<Integer>> parts() {
        HashMap<Integer, Set<Integer>> res = new HashMap<Integer, Set<Integer>>();
        for (Map.Entry<Integer, int[]> e : this.parts.entrySet()) {
            res.put(e.getKey(), Arrays.stream(e.getValue()).boxed().collect(Collectors.toSet()));
        }
        return res;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public String snapshotPath() {
        return this.snpPath;
    }

    public UUID requestId() {
        return this.reqId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 1: {
                if (!writer.writeMap("parts", this.parts, MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeUuid("requestId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeString("snpName", this.snpName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeString("snpPath", this.snpPath)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 1: {
                this.parts = reader.readMap("parts", MessageCollectionItemType.INT, MessageCollectionItemType.INT_ARR, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.reqId = reader.readUuid("requestId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.snpName = reader.readString("snpName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.snpPath = reader.readString("snpPath");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotFilesRequestMessage.class);
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public short directType() {
        return 178;
    }

    @Override
    public String toString() {
        return S.toString(SnapshotFilesRequestMessage.class, this, super.toString());
    }
}

