/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.lang.IgniteReducer;
import org.jetbrains.annotations.Nullable;

public class CacheObjectsReleaseFuture<T, R>
extends GridCompoundFuture<T, R> {
    public static final int DFLT_IGNITE_PARTITION_RELEASE_FUTURE_WARN_LIMIT = 10;
    private static final int PARTITION_RELEASE_FUTURE_WARN_LIMIT = IgniteSystemProperties.getInteger("IGNITE_PARTITION_RELEASE_FUTURE_WARN_LIMIT", 10);
    private AffinityTopologyVersion topVer;
    private String type;

    public CacheObjectsReleaseFuture(String type, AffinityTopologyVersion topVer) {
        this.type = type;
        this.topVer = topVer;
    }

    public CacheObjectsReleaseFuture(String type, AffinityTopologyVersion topVer, @Nullable IgniteReducer<T, R> rdc) {
        super(rdc);
        this.topVer = topVer;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Collection futures;
        int totalFuts;
        if (PARTITION_RELEASE_FUTURE_WARN_LIMIT >= 0) {
            this.compoundsReadLock();
            try {
                totalFuts = this.futuresCountNoLock();
                int firstFutsCnt = Math.min(PARTITION_RELEASE_FUTURE_WARN_LIMIT, totalFuts);
                futures = new ArrayList(firstFutsCnt);
                for (int i = 0; i < firstFutsCnt; ++i) {
                    futures.add(this.future(i));
                }
            }
            finally {
                this.compoundsReadUnlock();
            }
        } else {
            futures = this.futures();
            totalFuts = futures.size();
        }
        return this.type + "ReleaseFuture [topVer=" + this.topVer + ", totalFutures=" + totalFuts + ", futures=" + futures + "]";
    }
}

