/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.wal;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.wal.ClusterNode;
import org.apache.ignite.internal.management.wal.WalDeleteCommandArg;
import org.apache.ignite.internal.management.wal.WalTask;
import org.apache.ignite.internal.management.wal.WalTaskResult;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class WalDeleteCommand
implements ComputeCommand<WalDeleteCommandArg, WalTaskResult> {
    @Override
    public String description() {
        return "Delete unused archived wal segments on each node";
    }

    @Override
    public Class<WalDeleteCommandArg> argClass() {
        return WalDeleteCommandArg.class;
    }

    @Override
    public Class<WalTask> taskClass() {
        return WalTask.class;
    }

    @Override
    public String confirmationPrompt(WalDeleteCommandArg arg) {
        return "Warning: the command will delete unused WAL segments.";
    }

    @Override
    public void printResult(WalDeleteCommandArg arg, WalTaskResult taskRes, Consumer<String> printer) {
        ClusterNode node;
        printer.accept("WAL segments deleted for nodes:");
        printer.accept("");
        Map<String, Collection<String>> res = taskRes.results();
        Map<String, Exception> errors = taskRes.exceptions();
        Map<String, ClusterNode> nodesInfo = taskRes.getNodesInfo();
        for (Map.Entry<String, Collection<String>> entry : res.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            printer.accept("Node=" + node.getConsistentId());
            printer.accept("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            printer.accept("");
        }
        for (Map.Entry<String, Object> entry : errors.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            printer.accept("Node=" + node.getConsistentId());
            printer.accept("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            printer.accept("  failed with error: " + ((Exception)entry.getValue()).getMessage());
            printer.accept("");
        }
    }
}

