/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.tx.TxKeyLockType;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class TxVerboseKey
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String txKey;
    private TxKeyLockType lockType;
    private GridCacheVersion ownerVer;
    private boolean read;

    public TxVerboseKey() {
    }

    public TxVerboseKey(String txKey, TxKeyLockType lockType, GridCacheVersion ownerVer, boolean read) {
        this.txKey = txKey;
        this.lockType = lockType;
        this.ownerVer = ownerVer;
        this.read = read;
    }

    public String txKey() {
        return this.txKey;
    }

    public TxKeyLockType lockType() {
        return this.lockType;
    }

    public GridCacheVersion ownerVersion() {
        return this.ownerVer;
    }

    public boolean read() {
        return this.read;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.txKey);
        U.writeEnum(out, this.lockType);
        out.writeObject(this.ownerVer);
        out.writeBoolean(this.read);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.txKey = U.readString(in);
        this.lockType = TxKeyLockType.fromOrdinal(in.readByte());
        this.ownerVer = (GridCacheVersion)in.readObject();
        this.read = in.readBoolean();
    }

    public String toString() {
        return S.toString(TxVerboseKey.class, this);
    }
}

