/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionTask;
import org.apache.ignite.internal.management.encryption.EncryptionCacheGroupArg;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ReencryptionStatusTask
extends CacheGroupEncryptionTask<Long> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<EncryptionCacheGroupArg, CacheGroupEncryptionTask.SingleFieldDto<Long>> job(EncryptionCacheGroupArg arg) {
        return new ReencryptionStatusJob(arg, this.debug);
    }

    protected static class ReencryptionStatusResult
    extends CacheGroupEncryptionTask.SingleFieldDto<Long> {
        private static final long serialVersionUID = 0L;

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeLong((Long)this.value());
        }

        @Override
        protected void readExternalData(byte ver, ObjectInput in) throws IOException, ClassNotFoundException {
            this.value(in.readLong());
        }
    }

    private static class ReencryptionStatusJob
    extends CacheGroupEncryptionTask.ReencryptionBaseJob<Long> {
        private static final long serialVersionUID = 0L;

        protected ReencryptionStatusJob(@Nullable EncryptionCacheGroupArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected CacheGroupEncryptionTask.SingleFieldDto<Long> run0(CacheGroupContext grp) {
            long res = !this.ignite.context().encryption().reencryptionInProgress(grp.groupId()) ? -1L : this.ignite.context().encryption().getBytesLeftForReencryption(grp.groupId());
            return new ReencryptionStatusResult().value(res);
        }
    }
}

