/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.consistency;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.consistency.ConsistencyTaskResult;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;

public abstract class AbstractConsistencyTask<A, J>
extends VisorMultiNodeTask<A, ConsistencyTaskResult, J> {
    @Override
    protected ConsistencyTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        ConsistencyTaskResult taskRes = new ConsistencyTaskResult();
        StringBuilder sb = new StringBuilder();
        for (ComputeJobResult res : results) {
            String data;
            IgniteException e;
            if (res.isCancelled()) {
                taskRes.cancelled(true);
            }
            if ((e = res.getException()) != null) {
                taskRes.failed(true);
                sb.append("Node: ").append(res.getNode()).append("\n").append("  Exception: ").append(e).append("\n").append(X.getFullStackTrace(e)).append("\n");
            }
            if ((data = (String)res.getData()) == null) continue;
            sb.append("Node: ").append(res.getNode()).append("\n").append("  Result: ").append(data).append("\n");
        }
        if (sb.length() != 0) {
            taskRes.message(sb.toString());
        }
        return taskRes;
    }
}

