/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache.scan;

import java.util.Arrays;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.management.cache.scan.CacheScanTaskFormat;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class DefaultCacheScanTaskFormat
implements CacheScanTaskFormat {
    public static final String KEY = "Key";
    public static final String VALUE = "Value";

    @Override
    public String name() {
        return "default";
    }

    @Override
    public List<String> titles(Cache.Entry<Object, Object> first) {
        return Arrays.asList("Key Class", KEY, "Value Class", VALUE);
    }

    @Override
    public List<?> row(Cache.Entry<Object, Object> e) {
        Object k = e.getKey();
        Object v = e.getValue();
        return Arrays.asList(DefaultCacheScanTaskFormat.typeOf(k), DefaultCacheScanTaskFormat.valueOf(k), DefaultCacheScanTaskFormat.typeOf(v), DefaultCacheScanTaskFormat.valueOf(v));
    }

    private static String typeOf(Object o) {
        if (o != null) {
            Class<?> clazz = o.getClass();
            return clazz.isArray() ? IgniteUtils.compact(clazz.getComponentType().getName()) + "[]" : IgniteUtils.compact(o.getClass().getName());
        }
        return "n/a";
    }

    static String valueOf(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof byte[]) {
            return "size=" + ((byte[])o).length;
        }
        if (o instanceof Byte[]) {
            return "size=" + ((Byte[])o).length;
        }
        if (o instanceof boolean[]) {
            boolean[] arr = (boolean[])o;
            return DefaultCacheScanTaskFormat.arrayValue(arr.length, Arrays.toString(arr));
        }
        if (o instanceof char[]) {
            char[] arr = (char[])o;
            return DefaultCacheScanTaskFormat.arrayValue(arr.length, Arrays.toString(arr));
        }
        if (o instanceof short[]) {
            short[] arr = (short[])o;
            return DefaultCacheScanTaskFormat.arrayValue(arr.length, Arrays.toString(arr));
        }
        if (o instanceof int[]) {
            int[] arr = (int[])o;
            return DefaultCacheScanTaskFormat.arrayValue(arr.length, Arrays.toString(arr));
        }
        if (o instanceof long[]) {
            long[] arr = (long[])o;
            return DefaultCacheScanTaskFormat.arrayValue(arr.length, Arrays.toString(arr));
        }
        if (o instanceof float[]) {
            float[] arr = (float[])o;
            return DefaultCacheScanTaskFormat.arrayValue(arr.length, Arrays.toString(arr));
        }
        if (o instanceof double[]) {
            double[] arr = (double[])o;
            return DefaultCacheScanTaskFormat.arrayValue(arr.length, Arrays.toString(arr));
        }
        if (o instanceof Object[]) {
            return DefaultCacheScanTaskFormat.arrayValue(((Object[])o).length, "[" + S.joinToString(Arrays.asList((Object[])o), ", ", "...", 120, 0)) + "]";
        }
        if (o instanceof BinaryObject) {
            return DefaultCacheScanTaskFormat.binaryToString((BinaryObject)o);
        }
        return o.toString();
    }

    static String arrayValue(int length, String values) {
        return "size=" + length + ", values=" + values;
    }

    public static String binaryToString(BinaryObject obj) {
        int hash = obj.hashCode();
        if (obj instanceof BinaryObjectEx) {
            BinaryType meta;
            BinaryObjectEx objEx = (BinaryObjectEx)obj;
            try {
                meta = ((BinaryObjectEx)obj).rawType();
            }
            catch (BinaryObjectException ignore) {
                meta = null;
            }
            if (meta != null) {
                if (meta.isEnum()) {
                    try {
                        return obj.deserialize().toString();
                    }
                    catch (BinaryObjectException ignore) {
                        // empty catch block
                    }
                }
                SB buf = new SB(meta.typeName());
                if (meta.fieldNames() != null) {
                    buf.a(" [hash=").a(hash);
                    for (String name : meta.fieldNames()) {
                        Object val = objEx.field(name);
                        buf.a(", ").a(name).a('=').a(val);
                    }
                    buf.a(']');
                    return buf.toString();
                }
            }
        }
        return S.toString(obj.getClass().getSimpleName(), "hash", (Object)hash, false, "typeId", (Object)obj.type().typeId(), true);
    }
}

