/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.SystemViewCommandArg;
import org.apache.ignite.internal.management.SystemViewTask;
import org.apache.ignite.internal.management.SystemViewTaskResult;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.util.typedef.internal.U;

public class SystemViewCommand
implements ComputeCommand<SystemViewCommandArg, SystemViewTaskResult> {
    public static final String COLUMN_SEPARATOR = "    ";

    @Override
    public String description() {
        return "Print system view content";
    }

    @Override
    public Class<SystemViewCommandArg> argClass() {
        return SystemViewCommandArg.class;
    }

    @Override
    public Class<SystemViewTask> taskClass() {
        return SystemViewTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, SystemViewCommandArg arg) {
        if (arg.allNodes()) {
            return nodes;
        }
        return arg.nodeIds() != null ? CommandUtils.nodes(arg.nodeIds(), nodes) : CommandUtils.nodeOrNull(arg.nodeId(), nodes);
    }

    @Override
    public void printResult(SystemViewCommandArg arg, SystemViewTaskResult res, Consumer<String> printer) {
        if (res != null) {
            res.rows().forEach((nodeId, rows) -> {
                printer.accept("Results from node with ID: " + nodeId);
                printer.accept("---");
                SystemViewCommand.printTable(res.attributes(), res.types(), rows, printer);
                printer.accept("---" + U.nl());
            });
        } else {
            printer.accept("No system view with specified name was found [name=" + arg.systemViewName() + "]");
        }
    }

    public static void printTable(List<String> titles, List<SystemViewTask.SimpleType> types, List<List<?>> data, Consumer<String> printer) {
        List<Integer> colSzs = titles != null ? titles.stream().map(String::length).collect(Collectors.toList()) : types.stream().map(x -> 0).collect(Collectors.toList());
        ArrayList rows = new ArrayList(data.size());
        data.forEach(row -> {
            ListIterator colSzIter = colSzs.listIterator();
            rows.add(row.stream().map(val -> {
                String res = String.valueOf(val);
                colSzIter.set(Math.max((Integer)colSzIter.next(), res.length()));
                return res;
            }).collect(Collectors.toList()));
        });
        if (titles != null) {
            SystemViewCommand.printRow(titles, Collections.nCopies(titles.size(), SystemViewTask.SimpleType.STRING), colSzs, printer);
        }
        rows.forEach(row -> SystemViewCommand.printRow(row, types, colSzs, printer));
    }

    private static void printRow(Collection<String> row, Collection<SystemViewTask.SimpleType> types, Collection<Integer> colSzs, Consumer<String> printer) {
        Iterator<SystemViewTask.SimpleType> typeIter = types.iterator();
        Iterator<Integer> colSzsIter = colSzs.iterator();
        printer.accept(row.stream().map(colVal -> {
            SystemViewTask.SimpleType colType = (SystemViewTask.SimpleType)((Object)((Object)typeIter.next()));
            int colSz = (Integer)colSzsIter.next();
            String format = colType == SystemViewTask.SimpleType.DATE || colType == SystemViewTask.SimpleType.NUMBER ? "%" + colSz + "s" : "%-" + colSz + "s";
            return String.format(format, colVal);
        }).collect(Collectors.joining(COLUMN_SEPARATOR)));
    }
}

