/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NullIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public abstract class NullableInlineIndexKeyType<T extends IndexKey>
implements InlineIndexKeyType {
    public static final int CANT_BE_COMPARE = -2;
    public static final int COMPARE_UNSUPPORTED = Integer.MIN_VALUE;
    public static final int VARTYPE_HEADER_SIZE = 3;
    private final IndexKeyType type;
    protected final short keySize;

    protected NullableInlineIndexKeyType(IndexKeyType type, short keySize) {
        this.type = type;
        this.keySize = keySize;
    }

    @Override
    public IndexKeyType type() {
        return this.type;
    }

    @Override
    public int inlineSize(long pageAddr, int off) {
        byte type = PageUtils.getByte(pageAddr, off);
        if (type == IndexKeyType.NULL.code()) {
            return 1;
        }
        if (this.keySize > 0) {
            return this.keySize + 1;
        }
        return (PageUtils.getShort(pageAddr, off + 1) & Short.MAX_VALUE) + 3;
    }

    @Override
    public int inlineSize() {
        if (this.type == IndexKeyType.NULL) {
            return 1;
        }
        return this.keySize < 0 ? this.keySize : this.keySize + 1;
    }

    @Override
    public int inlineSize(IndexKey key) {
        if (key == NullIndexKey.INSTANCE) {
            return 1;
        }
        this.ensureKeyType(key);
        return this.inlineSize0(key);
    }

    @Override
    public IndexKey get(long pageAddr, int off, int maxSize) {
        if (this.keySize > 0 && this.keySize + 1 > maxSize) {
            return null;
        }
        if (maxSize < 1) {
            return null;
        }
        byte typeCode = PageUtils.getByte(pageAddr, off);
        if (typeCode == IndexKeyType.UNKNOWN.code()) {
            return null;
        }
        if (typeCode == IndexKeyType.NULL.code()) {
            return NullIndexKey.INSTANCE;
        }
        this.ensureKeyType(typeCode);
        return this.get0(pageAddr, off);
    }

    @Override
    public Boolean isNull(long pageAddr, int off, int maxSize) {
        if (maxSize < 1) {
            return null;
        }
        byte typeCode = PageUtils.getByte(pageAddr, off);
        if (typeCode == IndexKeyType.UNKNOWN.code()) {
            return null;
        }
        return typeCode == IndexKeyType.NULL.code();
    }

    @Override
    public int put(long pageAddr, int off, IndexKey key, int maxSize) {
        if (this.keySize > 0 && this.keySize + 1 > maxSize) {
            return 0;
        }
        if (this.keySize < 0 && maxSize < 4) {
            PageUtils.putByte(pageAddr, off, (byte)IndexKeyType.UNKNOWN.code());
            return 0;
        }
        if (key == NullIndexKey.INSTANCE) {
            PageUtils.putByte(pageAddr, off, (byte)IndexKeyType.NULL.code());
            return 1;
        }
        this.ensureKeyType(key);
        return this.put0(pageAddr, off, key, maxSize);
    }

    @Override
    public short keySize() {
        return this.keySize;
    }

    protected abstract int put0(long var1, int var3, T var4, int var5);

    protected abstract T get0(long var1, int var3);

    public static byte[] readBytes(long pageAddr, int off) {
        int size = PageUtils.getShort(pageAddr, off + 1) & Short.MAX_VALUE;
        return PageUtils.getBytes(pageAddr, off + 3, size);
    }

    @Override
    public int compare(long pageAddr, int off, int maxSize, IndexKey key) {
        byte typeCode;
        if (this.keySize > 0 && this.keySize + 1 > maxSize || maxSize < 1 || (typeCode = PageUtils.getByte(pageAddr, off)) == (byte)IndexKeyType.UNKNOWN.code()) {
            return -2;
        }
        if (typeCode == IndexKeyType.NULL.code()) {
            if (key == NullIndexKey.INSTANCE) {
                return 0;
            }
            return -1;
        }
        if (this.type.code() != typeCode) {
            return Integer.MIN_VALUE;
        }
        if (key == NullIndexKey.INSTANCE) {
            return 1;
        }
        return this.compare0(pageAddr, off, key);
    }

    private void ensureKeyType(int actCode) {
        if (this.type.code() != actCode) {
            throw new UnsupportedOperationException("Value type doesn't match: exp=" + this.type.code() + ", act=" + actCode);
        }
    }

    private void ensureKeyType(IndexKey key) {
        if (key != NullIndexKey.INSTANCE && this.type != key.type()) {
            throw new UnsupportedOperationException(key.type() + " cannot be used for inline type " + this.type());
        }
    }

    public abstract int compare0(long var1, int var3, IndexKey var4);

    protected abstract int inlineSize0(T var1);

    @Override
    public boolean inlinedFullValue(long pageAddr, int off, int maxSize) {
        if (maxSize < 1) {
            return false;
        }
        byte type = PageUtils.getByte(pageAddr, off);
        if (type == IndexKeyType.NULL.code()) {
            return true;
        }
        if (this.keySize > 0) {
            return maxSize >= this.keySize + 1;
        }
        return maxSize > 3 && (PageUtils.getShort(pageAddr, off + 1) & 0x8000) == 0;
    }
}

