/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class BinaryReaderHandles {
    private static final int MODE_EMPTY = 0;
    private static final int MODE_SINGLE = 1;
    private static final int MODE_MULTIPLE = 2;
    private int singlePos;
    private Object data;
    private int mode = 0;

    @Nullable
    public <T> T get(int pos) {
        switch (this.mode) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)(pos == this.singlePos ? this.data : null);
            }
        }
        assert (this.mode == 2);
        return (T)((Map)this.data).get(pos);
    }

    public void put(int pos, Object obj) {
        assert (pos >= 0);
        assert (obj != null);
        switch (this.mode) {
            case 0: {
                this.singlePos = pos;
                this.data = obj;
                this.mode = 1;
                break;
            }
            case 1: {
                HashMap<Integer, Object> newData = new HashMap<Integer, Object>(3, 1.0f);
                newData.put(this.singlePos, this.data);
                newData.put(pos, obj);
                this.singlePos = -1;
                this.data = newData;
                this.mode = 2;
                break;
            }
            default: {
                assert (this.mode == 2);
                Map data0 = (Map)this.data;
                data0.put(pos, obj);
            }
        }
    }

    public boolean isEmpty() {
        return this.mode == 0;
    }
}

