/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import sqlline.AbstractOutputFormat;
import sqlline.Rows;
import sqlline.SqlLine;

class XmlAttributeOutputFormat
extends AbstractOutputFormat {
    private static final String ALLOWED_NOT_ENCODE_SYMBOLS = "'>";

    XmlAttributeOutputFormat(SqlLine sqlLine) {
        super(sqlLine);
    }

    @Override
    public void printHeader(Rows.Row header) {
        this.sqlLine.output("<resultset>");
    }

    @Override
    public void printFooter(Rows.Row header) {
        this.sqlLine.output("</resultset>");
    }

    @Override
    public void printRow(Rows rows, Rows.Row header, Rows.Row row) {
        String[] head = header.values;
        String[] vals = row.values;
        StringBuilder result = new StringBuilder("  <result");
        for (int i = 0; i < head.length && i < vals.length; ++i) {
            result.append(' ').append(head[i]).append("=\"").append(SqlLine.xmlEncode(vals[i], ALLOWED_NOT_ENCODE_SYMBOLS)).append('\"');
        }
        result.append("/>");
        this.sqlLine.output(result.toString());
    }
}

