/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

class GridUriDeploymentClassLoader
extends URLClassLoader {
    GridUriDeploymentClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            try {
                try {
                    cls = this.findClass(name);
                }
                catch (ClassNotFoundException ignored) {
                    cls = super.loadClass(name, resolve);
                }
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClassNotFoundException("Failed to load class due to unexpected error: " + name, e);
            }
        }
        return cls;
    }

    public synchronized Class<?> loadClassIsolated(String name) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls == null) {
            try {
                cls = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClassNotFoundException("Failed to load class due to unexpected error: " + name, e);
            }
        }
        return cls;
    }

    @Deprecated
    public synchronized Class<?> loadClassGarOnly(String name) throws ClassNotFoundException {
        return this.loadClassIsolated(name);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = ClassLoader.getSystemResource(name);
        }
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream in = this.getResourceAsStreamIsolated(name);
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(name);
        }
        if (in == null) {
            in = super.getResourceAsStream(name);
        }
        return in;
    }

    @Nullable
    public InputStream getResourceAsStreamIsolated(String name) {
        URL url = this.findResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Deprecated
    @Nullable
    public InputStream getResourceAsStreamGarOnly(String name) {
        return this.getResourceAsStreamIsolated(name);
    }

    public String toString() {
        return S.toString(GridUriDeploymentClassLoader.class, (Object)this, (String)"urls", (Object)Arrays.toString(this.getURLs()));
    }
}

