/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.FromRowUsingCreator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@Deprecated
public abstract class GetterBasedSchemaProvider
implements SchemaProvider {
    @Deprecated
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter> fieldValueGetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1, @UnknownKeyFor @NonNull @Initialized Schema var2);

    public <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull T, @UnknownKeyFor @NonNull @Initialized Object>> fieldValueGetters(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return this.fieldValueGetters(targetTypeDescriptor.getRawType(), schema);
    }

    @Deprecated
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1, @UnknownKeyFor @NonNull @Initialized Schema var2);

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> fieldValueTypeInformations(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return this.fieldValueTypeInformations(targetTypeDescriptor.getRawType(), schema);
    }

    @Deprecated
    public abstract @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1, @UnknownKeyFor @NonNull @Initialized Schema var2);

    public @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator schemaTypeCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        return this.schemaTypeCreator(targetTypeDescriptor.getRawType(), schema);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        @NonNull Schema schema = (Schema)Verify.verifyNotNull((Object)this.schemaFor(typeDescriptor), (String)"can't create a ToRowFunction with null schema", (Object[])new Object[0]);
        return new ToRowWithValueGetters(schema);
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor) {
        return new FromRowUsingCreator<T>(typeDescriptor, this);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return super.hashCode();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return obj != null && this.getClass() == obj.getClass();
    }

    private static class RowValueGettersFactory<@UnknownKeyFor T>
    implements Factory<List<FieldValueGetter<T, Object>>> {
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>>> gettersFactory;
        @NotOnlyInitialized
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>>> cachingGettersFactory;
        private static final @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull @UnknownKeyFor @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> IDENTITY = new FieldValueGetter<Object, Object>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized Object get(@NonNull @UnknownKeyFor @Initialized Object object) {
                return object;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String name() {
                return "IDENTITY";
            }
        };

        static <T> @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>>> of(@UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>>> gettersFactory) {
            return new RowValueGettersFactory<T>(gettersFactory).cachingGettersFactory;
        }

        RowValueGettersFactory(@UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>>> gettersFactory) {
            this.gettersFactory = gettersFactory;
            this.cachingGettersFactory = new CachingFactory<List<FieldValueGetter<T, Object>>>(this);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>> create(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            List<FieldValueGetter<T, Object>> getters = this.gettersFactory.create(typeDescriptor, schema);
            ArrayList<FieldValueGetter<T, Object>> rowGetters = new ArrayList<FieldValueGetter<T, Object>>(getters.size());
            for (int i = 0; i < getters.size(); ++i) {
                rowGetters.add(this.rowValueGetter(getters.get(i), schema.getField(i).getType()));
            }
            return rowGetters;
        }

        static @UnknownKeyFor @NonNull @Initialized boolean needsConversion(@UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
            Schema.TypeName typeName = type.getTypeName();
            return typeName.equals((Object)Schema.TypeName.ROW) || typeName.isLogicalType() || (typeName.equals((Object)Schema.TypeName.ARRAY) || typeName.equals((Object)Schema.TypeName.ITERABLE)) && RowValueGettersFactory.needsConversion((Schema.FieldType)Verify.verifyNotNull((Object)type.getCollectionElementType())) || typeName.equals((Object)Schema.TypeName.MAP) && (RowValueGettersFactory.needsConversion((Schema.FieldType)Verify.verifyNotNull((Object)type.getMapKeyType())) || RowValueGettersFactory.needsConversion((Schema.FieldType)Verify.verifyNotNull((Object)type.getMapValueType())));
        }

        @UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object> rowValueGetter(@UnknownKeyFor @NonNull @Initialized FieldValueGetter base, @UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
            Schema.TypeName typeName = type.getTypeName();
            if (!RowValueGettersFactory.needsConversion(type)) {
                return base;
            }
            if (typeName.equals((Object)Schema.TypeName.ROW)) {
                return new GetRow(base, (Schema)Verify.verifyNotNull((Object)type.getRowSchema()), this.cachingGettersFactory);
            }
            if (typeName.equals((Object)Schema.TypeName.ARRAY)) {
                Schema.FieldType elementType = (Schema.FieldType)Verify.verifyNotNull((Object)type.getCollectionElementType());
                return elementType.getTypeName().equals((Object)Schema.TypeName.ROW) ? new GetEagerCollection(base, this.converter(elementType)) : new GetCollection(base, this.converter(elementType));
            }
            if (typeName.equals((Object)Schema.TypeName.ITERABLE)) {
                return new GetIterable(base, this.converter((Schema.FieldType)Verify.verifyNotNull((Object)type.getCollectionElementType())));
            }
            if (typeName.equals((Object)Schema.TypeName.MAP)) {
                return new GetMap(base, this.converter((Schema.FieldType)Verify.verifyNotNull((Object)type.getMapKeyType())), this.converter((Schema.FieldType)Verify.verifyNotNull((Object)type.getMapValueType())));
            }
            if (type.isLogicalType("OneOf")) {
                OneOfType oneOfType = type.getLogicalType(OneOfType.class);
                Schema oneOfSchema = oneOfType.getOneOfSchema();
                Map<String, Integer> values = oneOfType.getCaseEnumType().getValuesMap();
                HashMap converters = Maps.newHashMapWithExpectedSize((int)values.size());
                for (Map.Entry<String, Integer> kv : values.entrySet()) {
                    Schema.FieldType fieldType = oneOfSchema.getField(kv.getKey()).getType();
                    FieldValueGetter<?, ?> converter = this.converter(fieldType);
                    converters.put(kv.getValue(), converter);
                }
                return new GetOneOf(base, converters, oneOfType);
            }
            if (typeName.isLogicalType()) {
                return new GetLogicalInputType(base, (Schema.LogicalType)Verify.verifyNotNull(type.getLogicalType()));
            }
            return base;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> converter(@UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
            return this.rowValueGetter(IDENTITY, type);
        }

        static abstract class Converter<@UnknownKeyFor ObjectT, @UnknownKeyFor ValueT>
        implements FieldValueGetter<ObjectT, Object> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter<ObjectT, ValueT> getter;

            public Converter(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<ObjectT, ValueT> getter) {
                this.getter = getter;
            }

            abstract @UnknownKeyFor @NonNull @Initialized Object convert(ValueT var1);

            @Override
            public @Nullable @UnknownKeyFor @Initialized Object get(ObjectT object) {
                ValueT value = this.getter.get(object);
                if (value == null) {
                    return null;
                }
                return this.convert(value);
            }

            @Override
            public @Nullable @UnknownKeyFor @Initialized Object getRaw(ObjectT object) {
                return this.getter.getRaw(object);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized String name() {
                return this.getter.name();
            }
        }

        static class GetOneOf<@UnknownKeyFor T>
        extends Converter<T, OneOfType.Value> {
            final @UnknownKeyFor @NonNull @Initialized OneOfType oneOfType;
            final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull @UnknownKeyFor @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> converters;

            GetOneOf(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized OneOfType.Value> getter, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull @UnknownKeyFor @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> converters, @UnknownKeyFor @NonNull @Initialized OneOfType oneOfType) {
                super(getter);
                this.converters = converters;
                this.oneOfType = oneOfType;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized OneOfType.Value value) {
                EnumerationType.Value caseType = value.getCaseType();
                @NonNull @NonNull FieldValueGetter converter = (FieldValueGetter)Verify.verifyNotNull(this.converters.get(caseType.getValue()), (String)"Missing OneOf converter for case %s.", (Object[])new Object[]{caseType});
                return this.oneOfType.createValue(caseType, converter.get(value.getValue()));
            }
        }

        static class GetLogicalInputType<@UnknownKeyFor T>
        extends Converter<T, Object> {
            final @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType;

            GetLogicalInputType(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object> getter, @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType) {
                super(getter);
                this.logicalType = logicalType;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Object value) {
                return this.logicalType.toInputType(value);
            }
        }

        static class GetMap<@UnknownKeyFor T, @UnknownKeyFor K1, @UnknownKeyFor K2, @UnknownKeyFor V1, @UnknownKeyFor V2>
        extends Converter<T, Map<K1, V1>> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull K1, K2> keyConverter;
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull V1, V2> valueConverter;

            GetMap(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Map<@Nullable K1, @Nullable V1>> getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull K1, K2> keyConverter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull V1, V2> valueConverter) {
                super(getter);
                this.keyConverter = keyConverter;
                this.valueConverter = valueConverter;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@Nullable K2, @Nullable V2> convert(@UnknownKeyFor @NonNull @Initialized Map<@Nullable K1, @Nullable V1> value) {
                @Nullable @Nullable HashMap returnMap = Maps.newHashMapWithExpectedSize((int)value.size());
                for (Map.Entry<K1, V1> entry : value.entrySet()) {
                    returnMap.put(Optional.ofNullable(entry.getKey()).map(this.keyConverter::get).orElse(null), Optional.ofNullable(entry.getValue()).map(this.valueConverter::get).orElse(null));
                }
                return returnMap;
            }
        }

        static class GetIterable<@UnknownKeyFor T>
        extends Converter<T, Iterable> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter;

            GetIterable(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Iterable> getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Iterable value) {
                return Iterables.transform((Iterable)value, this.converter::get);
            }
        }

        static class GetCollection<@UnknownKeyFor T>
        extends Converter<T, Collection> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter;

            GetCollection(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Collection> getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Collection collection) {
                if (collection instanceof List) {
                    return Lists.transform((List)((List)collection), this.converter::get);
                }
                return Collections2.transform((Collection)collection, this.converter::get);
            }
        }

        static class GetEagerCollection<@UnknownKeyFor T>
        extends Converter<T, Collection> {
            final @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter;

            GetEagerCollection(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Collection> getter, @UnknownKeyFor @NonNull @Initialized FieldValueGetter converter) {
                super(getter);
                this.converter = converter;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized Collection collection) {
                ArrayList newList = new ArrayList(collection.size());
                for (Object obj : collection) {
                    newList.add(this.converter.get(obj));
                }
                return newList;
            }
        }

        static class GetRow<@UnknownKeyFor T, @UnknownKeyFor V>
        extends Converter<T, V> {
            final @UnknownKeyFor @NonNull @Initialized Schema schema;
            final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<V, @UnknownKeyFor @NonNull @Initialized Object>>> factory;

            GetRow(@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, V> getter, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<V, @UnknownKeyFor @NonNull @Initialized Object>>> factory) {
                super(getter);
                this.schema = schema;
                this.factory = factory;
            }

            @Override
            @UnknownKeyFor @NonNull @Initialized Object convert(V value) {
                return Row.withSchema(this.schema).withFieldValueGetters(this.factory, value);
            }
        }
    }

    private class ToRowWithValueGetters<@UnknownKeyFor T>
    implements SerializableFunction<T, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized Factory<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<T, @UnknownKeyFor @NonNull @Initialized Object>>> getterFactory;

        public ToRowWithValueGetters(Schema schema) {
            this.schema = schema;
            this.getterFactory = RowValueGettersFactory.of((typeDescriptor, schema1) -> GetterBasedSchemaProvider.this.fieldValueGetters(typeDescriptor, schema1));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row apply(T input) {
            return Row.withSchema(this.schema).withFieldValueGetters(this.getterFactory, input);
        }

        private @UnknownKeyFor @NonNull @Initialized GetterBasedSchemaProvider getOuter() {
            return GetterBasedSchemaProvider.this;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToRowWithValueGetters that = (ToRowWithValueGetters)o;
            return this.getOuter().equals(that.getOuter()) && this.schema.equals(that.schema);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(GetterBasedSchemaProvider.this, this.schema);
        }
    }
}

