/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VIFSDirectory;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import javax.swing.CellEditor;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

class IFSDirectoryCreateAction
implements VAction,
CellEditorListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String newName_ = ResourceLoader.getText("IFS_NEW_DIRECTORY");
    private static final String text_ = ResourceLoader.getText("ACTION_DIRECTORY_CREATE");
    private IFSFile directory_ = null;
    private boolean enabled_ = true;
    private IFSFile newDirectory_ = null;
    private VIFSDirectory newObject_ = null;
    private VIFSDirectory object_ = null;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public IFSDirectoryCreateAction(VIFSDirectory object, IFSFile directory) {
        this.directory_ = directory;
        this.object_ = object;
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public void editingCanceled(ChangeEvent event) {
    }

    @Override
    public void editingStopped(ChangeEvent event) {
        CellEditor editor = (CellEditor)event.getSource();
        editor.removeCellEditorListener(this);
        String newName = editor.getCellEditorValue().toString();
        try {
            if (Trace.isTraceOn()) {
                Trace.log(3, "Renaming new directory [" + this.newDirectory_.getName() + "] to [" + newName + "].");
            }
            this.newDirectory_.renameTo(new IFSFile(this.newDirectory_.getSystem(), this.newDirectory_.getParent(), newName));
            this.objectEventSupport_.fireObjectChanged(this.newObject_);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
    }

    @Override
    public String getText() {
        return text_;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled_;
    }

    @Override
    public void perform(VActionContext context) {
        try {
            int count = 1;
            boolean success = false;
            AS400 system = this.directory_.getSystem();
            this.newDirectory_ = new IFSFile(system, this.directory_, newName_);
            while (this.newDirectory_.exists()) {
                this.newDirectory_ = new IFSFile(system, this.directory_, newName_ + " (" + ++count + ")");
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "Creating new directory [" + this.newDirectory_.getName() + "].");
            }
            this.newDirectory_.mkdir();
            this.newObject_ = new VIFSDirectory(this.object_, this.newDirectory_);
            this.objectEventSupport_.fireObjectCreated(this.newObject_, this.object_);
            CellEditor editor = context.startEditing(this.newObject_, VIFSDirectory.NAME_PROPERTY);
            if (editor != null) {
                editor.addCellEditorListener(this);
            }
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    public String toString() {
        return this.getText();
    }
}

