/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBNativeDatabaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReturnObjectInformationRequestDS;
import com.ibm.as400.access.DBSQLAttributesDS;
import com.ibm.as400.access.DBSQLDescriptorDS;
import com.ibm.as400.access.DBSQLRPBDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.DBSQLResultSetDS;
import com.ibm.as400.access.DBStoragePool;
import com.ibm.as400.access.DBXARequestDS;
import com.ibm.as400.access.SystemProperties;
import java.lang.ref.SoftReference;

final class DBDSPool {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    private static DBSQLRPBDS[] dbsqlrpbdsPool_;
    private static final Object dbsqlrpbdsPoolLock_;
    private static DBSQLDescriptorDS[] dbsqldescriptordsPool_;
    private static final Object dbsqldescriptordsPoolLock_;
    private static DBSQLResultSetDS[] dbsqlresultsetdsPool_;
    private static final Object dbsqlresultsetdsPoolLock_;
    private static DBSQLRequestDS[] dbsqlrequestdsPool_;
    private static final Object dbsqlrequestdsPoolLock_;
    private static int dbsqlrequestdsPoolHighMark_;
    private static int dbsqlrequestdsPoolAllocations_;
    private static int dbsqlrequestdsPoolReclaimThreshold;
    private static DBNativeDatabaseRequestDS[] dbnativedatabaserequestdsPool_;
    private static final Object dbnativedatabaserequestdsPoolLock_;
    private static DBReturnObjectInformationRequestDS[] dbreturnobjectinformationrequestdsPool_;
    private static final Object dbreturnobjectinformationrequestdsPoolLock_;
    private static DBSQLAttributesDS[] dbsqlattributesdsPool_;
    private static final Object dbsqlattributesdsPoolLock_;
    private static DBXARequestDS[] dbxarequestdsPool_;
    private static final Object dbxarequestdsPoolLock_;
    static SoftReference[] dbreplyrequesteddsPool_;
    private static final Object dbreplyrequesteddsPoolLock_;
    private static int dbReplyRequestedPoolSearchStart_;
    private static final int DB_REPLY_REQUEST_POOL_SEARCH_RESET = 4096;
    private static final int DB_REPLY_REQUEST_LOCALITY = 256;
    private static int dbReplyRequestedPoolSearchCount_;
    private static boolean dbReplyRequestedPoolFull_;
    static final DBStoragePool storagePool_;
    static String changeTime;
    static boolean noDBReplyPooling;
    static boolean monitor;

    private DBDSPool() {
    }

    static void returnToDBReplyRequestedPool(int poolIndex) {
        if (poolIndex >= 0) {
            if (dbReplyRequestedPoolFull_) {
                dbReplyRequestedPoolFull_ = false;
                dbReplyRequestedPoolSearchStart_ = poolIndex;
            } else if (poolIndex < dbReplyRequestedPoolSearchStart_ && poolIndex >= dbReplyRequestedPoolSearchStart_ - 256) {
                dbReplyRequestedPoolSearchStart_ = poolIndex;
            }
        }
    }

    public static int getDBReplyRequestedDSPoolSize() {
        return dbreplyrequesteddsPool_.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBReplyRequestedDS getDBReplyRequestedDS() {
        if (noDBReplyPooling) {
            DBReplyRequestedDS unpooledDS = new DBReplyRequestedDS(monitor, -1);
            unpooledDS.canUse();
            unpooledDS.setInPool(false);
            return unpooledDS;
        }
        Object object = dbreplyrequesteddsPoolLock_;
        synchronized (object) {
            DBReplyRequestedDS ds;
            DBReplyRequestedDS pooledDs;
            int i;
            SoftReference[] pool = dbreplyrequesteddsPool_;
            int max = pool.length;
            int searchStart = dbReplyRequestedPoolSearchStart_;
            if (dbReplyRequestedPoolFull_) {
                searchStart = pool.length;
            }
            if (dbReplyRequestedPoolSearchCount_ > 4096) {
                dbReplyRequestedPoolFull_ = false;
                searchStart = 0;
                dbReplyRequestedPoolSearchCount_ = 0;
            }
            ++dbReplyRequestedPoolSearchCount_;
            for (i = searchStart; i < pool.length; ++i) {
                if (pool[i] == null) {
                    pooledDs = new DBReplyRequestedDS(monitor, i);
                    pooledDs.canUse();
                    pooledDs.setInPool(true);
                    pool[i] = new SoftReference<DBReplyRequestedDS>(pooledDs);
                    dbReplyRequestedPoolSearchStart_ = i + 1;
                    return pooledDs;
                }
                ds = (DBReplyRequestedDS)pool[i].get();
                if (ds == null || ds.storage_ == null) {
                    ds = new DBReplyRequestedDS(monitor, i);
                    ds.canUse();
                    ds.setInPool(true);
                    pool[i] = new SoftReference<DBReplyRequestedDS>(ds);
                    dbReplyRequestedPoolSearchStart_ = i + 1;
                    return ds;
                }
                if (ds.inUse_ || !ds.canUse() || ds.storage_ == null) continue;
                ds.initialize();
                dbReplyRequestedPoolSearchStart_ = i + 1;
                return ds;
            }
            if (max * 2 < 16385) {
                if (monitor) {
                    System.out.println("Expanding DBDSPool to size " + max * 2);
                    for (i = 0; i < max; ++i) {
                        ds = (DBReplyRequestedDS)pool[i].get();
                        if (ds == null) {
                            System.out.println("Entry " + i + " : null");
                            continue;
                        }
                        System.out.println("Entry " + i + " : " + ds.getAllocatedLocation());
                    }
                }
                SoftReference[] temp = new SoftReference[max * 2];
                System.arraycopy(pool, 0, temp, 0, max);
                pooledDs = new DBReplyRequestedDS(monitor, max);
                pooledDs.canUse();
                pooledDs.setInPool(true);
                temp[max] = new SoftReference<DBReplyRequestedDS>(pooledDs);
                dbreplyrequesteddsPool_ = temp;
                dbReplyRequestedPoolSearchStart_ = 0;
                return pooledDs;
            }
            DBReplyRequestedDS nonpooledDS = new DBReplyRequestedDS(monitor, -1);
            nonpooledDS.canUse();
            nonpooledDS.setInPool(false);
            if (!dbReplyRequestedPoolFull_) {
                dbReplyRequestedPoolFull_ = true;
            }
            return nonpooledDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBXARequestDS getDBXARequestDS(int a, int b, int c, int d) {
        Object object = dbxarequestdsPoolLock_;
        synchronized (object) {
            DBXARequestDS[] pool = dbxarequestdsPool_;
            int max = pool.length;
            for (int i = 0; i < pool.length; ++i) {
                if (pool[i] == null) {
                    DBXARequestDS request = new DBXARequestDS(a, b, c, d);
                    request.canUse();
                    pool[i] = request;
                    return request;
                }
                if (pool[i].inUse_ || !pool[i].canUse()) continue;
                pool[i].initialize(a, b, c, d);
                return pool[i];
            }
            DBXARequestDS[] temp = new DBXARequestDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            DBXARequestDS request = new DBXARequestDS(a, b, c, d);
            request.canUse();
            temp[max] = request;
            dbxarequestdsPool_ = temp;
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLAttributesDS getDBSQLAttributesDS(int a, int b, int c, int d) {
        Object object = dbsqlattributesdsPoolLock_;
        synchronized (object) {
            DBSQLAttributesDS[] pool = dbsqlattributesdsPool_;
            int max = pool.length;
            for (int i = 0; i < pool.length; ++i) {
                if (pool[i] == null) {
                    DBSQLAttributesDS request = new DBSQLAttributesDS(a, b, c, d);
                    request.canUse();
                    pool[i] = request;
                    return request;
                }
                if (pool[i].inUse_ || !pool[i].canUse()) continue;
                pool[i].initialize(a, b, c, d);
                return pool[i];
            }
            DBSQLAttributesDS[] temp = new DBSQLAttributesDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            DBSQLAttributesDS ds = new DBSQLAttributesDS(a, b, c, d);
            ds.canUse();
            temp[max] = ds;
            dbsqlattributesdsPool_ = temp;
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBNativeDatabaseRequestDS getDBNativeDatabaseRequestDS(int a, int b, int c, int d) {
        Object object = dbnativedatabaserequestdsPoolLock_;
        synchronized (object) {
            DBNativeDatabaseRequestDS[] pool = dbnativedatabaserequestdsPool_;
            int max = pool.length;
            for (int i = 0; i < pool.length; ++i) {
                if (pool[i] == null) {
                    DBNativeDatabaseRequestDS request = new DBNativeDatabaseRequestDS(a, b, c, d);
                    request.canUse();
                    pool[i] = request;
                    return request;
                }
                if (pool[i].inUse_ || !pool[i].canUse()) continue;
                pool[i].initialize(a, b, c, d);
                return pool[i];
            }
            DBNativeDatabaseRequestDS[] temp = new DBNativeDatabaseRequestDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            DBNativeDatabaseRequestDS newRequest = new DBNativeDatabaseRequestDS(a, b, c, d);
            newRequest.canUse();
            temp[max] = newRequest;
            dbnativedatabaserequestdsPool_ = temp;
            return newRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBReturnObjectInformationRequestDS getDBReturnObjectInformationRequestDS(int a, int b, int c, int d) {
        Object object = dbreturnobjectinformationrequestdsPoolLock_;
        synchronized (object) {
            DBReturnObjectInformationRequestDS[] pool = dbreturnobjectinformationrequestdsPool_;
            int max = pool.length;
            for (int i = 0; i < pool.length; ++i) {
                DBReturnObjectInformationRequestDS request;
                if (pool[i] == null) {
                    request = new DBReturnObjectInformationRequestDS(a, b, c, d);
                    request.canUse();
                    pool[i] = request;
                    return request;
                }
                request = pool[i];
                synchronized (request) {
                    if (!pool[i].inUse_ && pool[i].canUse()) {
                        pool[i].initialize(a, b, c, d);
                        return pool[i];
                    }
                    continue;
                }
            }
            DBReturnObjectInformationRequestDS[] temp = new DBReturnObjectInformationRequestDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            DBReturnObjectInformationRequestDS newRequest = new DBReturnObjectInformationRequestDS(a, b, c, d);
            newRequest.canUse();
            temp[max] = newRequest;
            dbreturnobjectinformationrequestdsPool_ = temp;
            return newRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLDescriptorDS getDBSQLDescriptorDS(int a, int b, int c, int d) {
        Object object = dbsqldescriptordsPoolLock_;
        synchronized (object) {
            DBSQLDescriptorDS ds;
            DBSQLDescriptorDS[] pool = dbsqldescriptordsPool_;
            int max = pool.length;
            for (int i = 0; i < max; ++i) {
                if (pool[i] == null) {
                    ds = new DBSQLDescriptorDS(a, b, c, d);
                    ds.canUse();
                    pool[i] = ds;
                    return ds;
                }
                ds = pool[i];
                synchronized (ds) {
                    if (!pool[i].inUse_ && pool[i].canUse()) {
                        pool[i].initialize(a, b, c, d);
                        return pool[i];
                    }
                    continue;
                }
            }
            DBSQLDescriptorDS[] temp = new DBSQLDescriptorDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            ds = new DBSQLDescriptorDS(a, b, c, d);
            ds.canUse();
            temp[max] = ds;
            dbsqldescriptordsPool_ = temp;
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLRequestDS getDBSQLRequestDS(int a, int b, int c, int d) {
        Object object = dbsqlrequestdsPoolLock_;
        synchronized (object) {
            int i;
            DBSQLRequestDS[] pool = dbsqlrequestdsPool_;
            int max = pool.length;
            if (++dbsqlrequestdsPoolAllocations_ > dbsqlrequestdsPoolReclaimThreshold) {
                dbsqlrequestdsPoolAllocations_ = 0;
                for (i = dbsqlrequestdsPoolHighMark_ + 1; i < max; ++i) {
                    if (pool[i] == null || pool[i].inUse_ || !pool[i].canUse()) continue;
                    pool[i].reclaim();
                    pool[i].returnToPool();
                }
                dbsqlrequestdsPoolHighMark_ = 0;
            }
            for (i = 0; i < max; ++i) {
                if (pool[i] == null) {
                    DBSQLRequestDS ds = new DBSQLRequestDS(a, b, c, d);
                    ds.canUse();
                    pool[i] = ds;
                    if (i > dbsqlrequestdsPoolHighMark_) {
                        dbsqlrequestdsPoolHighMark_ = i;
                    }
                    return ds;
                }
                if (pool[i].inUse_ || !pool[i].canUse()) continue;
                pool[i].initialize(a, b, c, d);
                if (i > dbsqlrequestdsPoolHighMark_) {
                    dbsqlrequestdsPoolHighMark_ = i;
                }
                return pool[i];
            }
            DBSQLRequestDS[] temp = new DBSQLRequestDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            DBSQLRequestDS ds = new DBSQLRequestDS(a, b, c, d);
            ds.canUse();
            temp[max] = ds;
            dbsqlrequestdsPool_ = temp;
            if (max > dbsqlrequestdsPoolHighMark_) {
                dbsqlrequestdsPoolHighMark_ = max;
            }
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLResultSetDS getDBSQLResultSetDS(int a, int b, int c, int d) {
        Object object = dbsqlresultsetdsPoolLock_;
        synchronized (object) {
            DBSQLResultSetDS[] pool = dbsqlresultsetdsPool_;
            int max = pool.length;
            for (int i = 0; i < max; ++i) {
                if (pool[i] == null) {
                    DBSQLResultSetDS ds = new DBSQLResultSetDS(a, b, c, d);
                    ds.canUse();
                    pool[i] = ds;
                    return ds;
                }
                if (pool[i].inUse_ || !pool[i].canUse()) continue;
                pool[i].initialize(a, b, c, d);
                return pool[i];
            }
            DBSQLResultSetDS[] temp = new DBSQLResultSetDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            DBSQLResultSetDS ds = new DBSQLResultSetDS(a, b, c, d);
            ds.canUse();
            temp[max] = ds;
            dbsqlresultsetdsPool_ = temp;
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLRPBDS getDBSQLRPBDS(int a, int b, int c, int d) {
        Object object = dbsqlrpbdsPoolLock_;
        synchronized (object) {
            DBSQLRPBDS[] pool = dbsqlrpbdsPool_;
            int max = pool.length;
            for (int i = 0; i < max; ++i) {
                if (pool[i] == null) {
                    DBSQLRPBDS ds = new DBSQLRPBDS(a, b, c, d);
                    ds.canUse();
                    pool[i] = ds;
                    return ds;
                }
                if (pool[i].inUse_ || !pool[i].canUse()) continue;
                pool[i].initialize(a, b, c, d);
                return pool[i];
            }
            DBSQLRPBDS[] temp = new DBSQLRPBDS[max * 2];
            System.arraycopy(pool, 0, temp, 0, max);
            DBSQLRPBDS ds = new DBSQLRPBDS(a, b, c, d);
            ds.canUse();
            temp[max] = ds;
            dbsqlrpbdsPool_ = temp;
            return ds;
        }
    }

    static {
        String monitorProperty;
        dbsqlrpbdsPool_ = new DBSQLRPBDS[4];
        dbsqlrpbdsPoolLock_ = new Object();
        dbsqldescriptordsPool_ = new DBSQLDescriptorDS[4];
        dbsqldescriptordsPoolLock_ = new Object();
        dbsqlresultsetdsPool_ = new DBSQLResultSetDS[4];
        dbsqlresultsetdsPoolLock_ = new Object();
        dbsqlrequestdsPool_ = new DBSQLRequestDS[4];
        dbsqlrequestdsPoolLock_ = new Object();
        dbsqlrequestdsPoolHighMark_ = 0;
        dbsqlrequestdsPoolAllocations_ = 0;
        dbsqlrequestdsPoolReclaimThreshold = 1000;
        dbnativedatabaserequestdsPool_ = new DBNativeDatabaseRequestDS[4];
        dbnativedatabaserequestdsPoolLock_ = new Object();
        dbreturnobjectinformationrequestdsPool_ = new DBReturnObjectInformationRequestDS[4];
        dbreturnobjectinformationrequestdsPoolLock_ = new Object();
        dbsqlattributesdsPool_ = new DBSQLAttributesDS[4];
        dbsqlattributesdsPoolLock_ = new Object();
        dbxarequestdsPool_ = new DBXARequestDS[4];
        dbxarequestdsPoolLock_ = new Object();
        dbreplyrequesteddsPool_ = new SoftReference[4];
        dbreplyrequesteddsPoolLock_ = new Object();
        dbReplyRequestedPoolSearchStart_ = 0;
        dbReplyRequestedPoolSearchCount_ = 0;
        dbReplyRequestedPoolFull_ = false;
        storagePool_ = new DBStoragePool();
        changeTime = "2010/06/14 08:09";
        noDBReplyPooling = false;
        monitor = false;
        String noPoolingProperty = SystemProperties.getProperty("com.ibm.as400.access.noDBReplyPooling");
        if (noPoolingProperty != null) {
            noDBReplyPooling = true;
        }
        if ((monitorProperty = SystemProperties.getProperty("com.ibm.as400.access.DBDSPool.monitor")) != null) {
            monitor = true;
        }
    }
}

