/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

@Internal
public final class ValueSerializer<T extends Value>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private LinkedHashMap<String, KryoRegistration> kryoRegistrations;
    private transient Kryo kryo;
    private transient T copyInstance;

    public ValueSerializer(Class<T> type) {
        this.type = Preconditions.checkNotNull(type);
        this.kryoRegistrations = ValueSerializer.asKryoRegistrations(type);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public ValueSerializer<T> duplicate() {
        return new ValueSerializer<T>(this.type);
    }

    @Override
    public T createInstance() {
        return (T)((Value)InstantiationUtil.instantiate(this.type));
    }

    @Override
    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)((Value)KryoUtils.copy(from, this.kryo, this));
    }

    @Override
    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)((Value)KryoUtils.copy(from, reuse, this.kryo, this));
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        value.write(target);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return (T)this.deserialize((T)this.createInstance(), source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (this.copyInstance == null) {
            this.copyInstance = (Value)InstantiationUtil.instantiate(this.type);
        }
        this.copyInstance.read(source);
        this.copyInstance.write(target);
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy((InstantiatorStrategy)instantiatorStrategy);
            this.kryo.setAsmEnabled(true);
            KryoUtils.applyRegistrations(this.kryo, this.kryoRegistrations.values(), this.kryo.getNextRegistrationId());
        }
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ValueSerializer) {
            ValueSerializer other = (ValueSerializer)obj;
            return this.type == other.type;
        }
        return false;
    }

    private Class<T> getValueType() {
        return this.type;
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new ValueSerializerSnapshot<T>(this.type);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.kryoRegistrations == null) {
            this.kryoRegistrations = ValueSerializer.asKryoRegistrations(this.type);
        }
    }

    private static LinkedHashMap<String, KryoRegistration> asKryoRegistrations(Class<?> type) {
        Preconditions.checkNotNull(type);
        LinkedHashMap<String, KryoRegistration> registration = CollectionUtil.newLinkedHashMapWithExpectedSize(1);
        registration.put(type.getClass().getName(), new KryoRegistration(type));
        return registration;
    }

    public static final class ValueSerializerSnapshot<T extends Value>
    extends GenericTypeSerializerSnapshot<T, ValueSerializer> {
        public ValueSerializerSnapshot() {
        }

        ValueSerializerSnapshot(Class<T> typeClass) {
            super(typeClass);
        }

        @Override
        protected TypeSerializer<T> createSerializer(Class<T> typeClass) {
            return new ValueSerializer<T>(typeClass);
        }

        @Override
        protected Class<T> getTypeClass(ValueSerializer serializer) {
            return serializer.type;
        }

        @Override
        protected Class<?> serializerClass() {
            return ValueSerializer.class;
        }
    }
}

