/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filestoresult;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.filestoresult.FilesToResult;
import org.apache.hop.pipeline.transforms.filestoresult.FilesToResultData;

@Transform(id="FilesToResult", image="filestoresult.svg", name="i18n::FilesToResult.Name", description="i18n::FilesToResult.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Workflow", keywords={"i18n::FilesToResultMeta.keyword"}, documentationUrl="/pipeline/transforms/filestoresult.html")
public class FilesToResultMeta
extends BaseTransformMeta<FilesToResult, FilesToResultData> {
    private static final Class<?> PKG = FilesToResultMeta.class;
    @HopMetadataProperty(key="filename_field")
    private String filenameField;
    @HopMetadataProperty(key="file_type", storeWithCode=true)
    private ResultFile.FileType fileType;

    public FilesToResultMeta() {
        this.fileType = ResultFile.FileType.GENERAL;
    }

    public FilesToResultMeta(FilesToResultMeta m) {
        this.filenameField = m.filenameField;
        this.fileType = m.fileType;
    }

    public FilesToResultMeta clone() {
        return new FilesToResultMeta(this);
    }

    public void setDefault() {
        this.filenameField = null;
        this.fileType = ResultFile.FileType.GENERAL;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"FilesToResultMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"FilesToResultMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public ResultFile.FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(ResultFile.FileType fileType) {
        this.fileType = fileType;
    }
}

