/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.secretmanager.v1beta2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.secretmanager.v1beta2.AccessSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta2.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1beta2.AddSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta2.CreateSecretRequest;
import com.google.cloud.secretmanager.v1beta2.DeleteSecretRequest;
import com.google.cloud.secretmanager.v1beta2.DestroySecretVersionRequest;
import com.google.cloud.secretmanager.v1beta2.DisableSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta2.EnableSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta2.GetSecretRequest;
import com.google.cloud.secretmanager.v1beta2.GetSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta2.ListSecretVersionsRequest;
import com.google.cloud.secretmanager.v1beta2.ListSecretVersionsResponse;
import com.google.cloud.secretmanager.v1beta2.ListSecretsRequest;
import com.google.cloud.secretmanager.v1beta2.ListSecretsResponse;
import com.google.cloud.secretmanager.v1beta2.LocationName;
import com.google.cloud.secretmanager.v1beta2.ProjectName;
import com.google.cloud.secretmanager.v1beta2.Secret;
import com.google.cloud.secretmanager.v1beta2.SecretManagerServiceSettings;
import com.google.cloud.secretmanager.v1beta2.SecretName;
import com.google.cloud.secretmanager.v1beta2.SecretPayload;
import com.google.cloud.secretmanager.v1beta2.SecretVersion;
import com.google.cloud.secretmanager.v1beta2.SecretVersionName;
import com.google.cloud.secretmanager.v1beta2.UpdateSecretRequest;
import com.google.cloud.secretmanager.v1beta2.stub.SecretManagerServiceStub;
import com.google.cloud.secretmanager.v1beta2.stub.SecretManagerServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SecretManagerServiceClient
implements BackgroundResource {
    private final SecretManagerServiceSettings settings;
    private final SecretManagerServiceStub stub;

    public static final SecretManagerServiceClient create() throws IOException {
        return SecretManagerServiceClient.create(SecretManagerServiceSettings.newBuilder().build());
    }

    public static final SecretManagerServiceClient create(SecretManagerServiceSettings settings) throws IOException {
        return new SecretManagerServiceClient(settings);
    }

    public static final SecretManagerServiceClient create(SecretManagerServiceStub stub) {
        return new SecretManagerServiceClient(stub);
    }

    protected SecretManagerServiceClient(SecretManagerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecretManagerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SecretManagerServiceClient(SecretManagerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SecretManagerServiceSettings getSettings() {
        return this.settings;
    }

    public SecretManagerServiceStub getStub() {
        return this.stub;
    }

    public final ListSecretsPagedResponse listSecrets(LocationName parent) {
        ListSecretsRequest request = ListSecretsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSecrets(request);
    }

    public final ListSecretsPagedResponse listSecrets(ProjectName parent) {
        ListSecretsRequest request = ListSecretsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSecrets(request);
    }

    public final ListSecretsPagedResponse listSecrets(String parent) {
        ListSecretsRequest request = ListSecretsRequest.newBuilder().setParent(parent).build();
        return this.listSecrets(request);
    }

    public final ListSecretsPagedResponse listSecrets(ListSecretsRequest request) {
        return (ListSecretsPagedResponse)((Object)this.listSecretsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSecretsRequest, ListSecretsPagedResponse> listSecretsPagedCallable() {
        return this.stub.listSecretsPagedCallable();
    }

    public final UnaryCallable<ListSecretsRequest, ListSecretsResponse> listSecretsCallable() {
        return this.stub.listSecretsCallable();
    }

    public final Secret createSecret(LocationName parent, String secretId, Secret secret) {
        CreateSecretRequest request = CreateSecretRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSecretId(secretId).setSecret(secret).build();
        return this.createSecret(request);
    }

    public final Secret createSecret(ProjectName parent, String secretId, Secret secret) {
        CreateSecretRequest request = CreateSecretRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSecretId(secretId).setSecret(secret).build();
        return this.createSecret(request);
    }

    public final Secret createSecret(String parent, String secretId, Secret secret) {
        CreateSecretRequest request = CreateSecretRequest.newBuilder().setParent(parent).setSecretId(secretId).setSecret(secret).build();
        return this.createSecret(request);
    }

    public final Secret createSecret(CreateSecretRequest request) {
        return (Secret)this.createSecretCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSecretRequest, Secret> createSecretCallable() {
        return this.stub.createSecretCallable();
    }

    public final SecretVersion addSecretVersion(SecretName parent, SecretPayload payload) {
        AddSecretVersionRequest request = AddSecretVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPayload(payload).build();
        return this.addSecretVersion(request);
    }

    public final SecretVersion addSecretVersion(String parent, SecretPayload payload) {
        AddSecretVersionRequest request = AddSecretVersionRequest.newBuilder().setParent(parent).setPayload(payload).build();
        return this.addSecretVersion(request);
    }

    public final SecretVersion addSecretVersion(AddSecretVersionRequest request) {
        return (SecretVersion)this.addSecretVersionCallable().call((Object)request);
    }

    public final UnaryCallable<AddSecretVersionRequest, SecretVersion> addSecretVersionCallable() {
        return this.stub.addSecretVersionCallable();
    }

    public final Secret getSecret(SecretName name) {
        GetSecretRequest request = GetSecretRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSecret(request);
    }

    public final Secret getSecret(String name) {
        GetSecretRequest request = GetSecretRequest.newBuilder().setName(name).build();
        return this.getSecret(request);
    }

    public final Secret getSecret(GetSecretRequest request) {
        return (Secret)this.getSecretCallable().call((Object)request);
    }

    public final UnaryCallable<GetSecretRequest, Secret> getSecretCallable() {
        return this.stub.getSecretCallable();
    }

    public final Secret updateSecret(Secret secret, FieldMask updateMask) {
        UpdateSecretRequest request = UpdateSecretRequest.newBuilder().setSecret(secret).setUpdateMask(updateMask).build();
        return this.updateSecret(request);
    }

    public final Secret updateSecret(UpdateSecretRequest request) {
        return (Secret)this.updateSecretCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSecretRequest, Secret> updateSecretCallable() {
        return this.stub.updateSecretCallable();
    }

    public final void deleteSecret(SecretName name) {
        DeleteSecretRequest request = DeleteSecretRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSecret(request);
    }

    public final void deleteSecret(String name) {
        DeleteSecretRequest request = DeleteSecretRequest.newBuilder().setName(name).build();
        this.deleteSecret(request);
    }

    public final void deleteSecret(DeleteSecretRequest request) {
        this.deleteSecretCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSecretRequest, Empty> deleteSecretCallable() {
        return this.stub.deleteSecretCallable();
    }

    public final ListSecretVersionsPagedResponse listSecretVersions(SecretName parent) {
        ListSecretVersionsRequest request = ListSecretVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSecretVersions(request);
    }

    public final ListSecretVersionsPagedResponse listSecretVersions(String parent) {
        ListSecretVersionsRequest request = ListSecretVersionsRequest.newBuilder().setParent(parent).build();
        return this.listSecretVersions(request);
    }

    public final ListSecretVersionsPagedResponse listSecretVersions(ListSecretVersionsRequest request) {
        return (ListSecretVersionsPagedResponse)((Object)this.listSecretVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSecretVersionsRequest, ListSecretVersionsPagedResponse> listSecretVersionsPagedCallable() {
        return this.stub.listSecretVersionsPagedCallable();
    }

    public final UnaryCallable<ListSecretVersionsRequest, ListSecretVersionsResponse> listSecretVersionsCallable() {
        return this.stub.listSecretVersionsCallable();
    }

    public final SecretVersion getSecretVersion(SecretVersionName name) {
        GetSecretVersionRequest request = GetSecretVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSecretVersion(request);
    }

    public final SecretVersion getSecretVersion(String name) {
        GetSecretVersionRequest request = GetSecretVersionRequest.newBuilder().setName(name).build();
        return this.getSecretVersion(request);
    }

    public final SecretVersion getSecretVersion(GetSecretVersionRequest request) {
        return (SecretVersion)this.getSecretVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSecretVersionRequest, SecretVersion> getSecretVersionCallable() {
        return this.stub.getSecretVersionCallable();
    }

    public final AccessSecretVersionResponse accessSecretVersion(SecretVersionName name) {
        AccessSecretVersionRequest request = AccessSecretVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.accessSecretVersion(request);
    }

    public final AccessSecretVersionResponse accessSecretVersion(String name) {
        AccessSecretVersionRequest request = AccessSecretVersionRequest.newBuilder().setName(name).build();
        return this.accessSecretVersion(request);
    }

    public final AccessSecretVersionResponse accessSecretVersion(AccessSecretVersionRequest request) {
        return (AccessSecretVersionResponse)this.accessSecretVersionCallable().call((Object)request);
    }

    public final UnaryCallable<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionCallable() {
        return this.stub.accessSecretVersionCallable();
    }

    public final SecretVersion disableSecretVersion(SecretVersionName name) {
        DisableSecretVersionRequest request = DisableSecretVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disableSecretVersion(request);
    }

    public final SecretVersion disableSecretVersion(String name) {
        DisableSecretVersionRequest request = DisableSecretVersionRequest.newBuilder().setName(name).build();
        return this.disableSecretVersion(request);
    }

    public final SecretVersion disableSecretVersion(DisableSecretVersionRequest request) {
        return (SecretVersion)this.disableSecretVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DisableSecretVersionRequest, SecretVersion> disableSecretVersionCallable() {
        return this.stub.disableSecretVersionCallable();
    }

    public final SecretVersion enableSecretVersion(SecretVersionName name) {
        EnableSecretVersionRequest request = EnableSecretVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.enableSecretVersion(request);
    }

    public final SecretVersion enableSecretVersion(String name) {
        EnableSecretVersionRequest request = EnableSecretVersionRequest.newBuilder().setName(name).build();
        return this.enableSecretVersion(request);
    }

    public final SecretVersion enableSecretVersion(EnableSecretVersionRequest request) {
        return (SecretVersion)this.enableSecretVersionCallable().call((Object)request);
    }

    public final UnaryCallable<EnableSecretVersionRequest, SecretVersion> enableSecretVersionCallable() {
        return this.stub.enableSecretVersionCallable();
    }

    public final SecretVersion destroySecretVersion(SecretVersionName name) {
        DestroySecretVersionRequest request = DestroySecretVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.destroySecretVersion(request);
    }

    public final SecretVersion destroySecretVersion(String name) {
        DestroySecretVersionRequest request = DestroySecretVersionRequest.newBuilder().setName(name).build();
        return this.destroySecretVersion(request);
    }

    public final SecretVersion destroySecretVersion(DestroySecretVersionRequest request) {
        return (SecretVersion)this.destroySecretVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DestroySecretVersionRequest, SecretVersion> destroySecretVersionCallable() {
        return this.stub.destroySecretVersionCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSecretVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion, ListSecretVersionsPage, ListSecretVersionsFixedSizeCollection> {
        private ListSecretVersionsFixedSizeCollection(List<ListSecretVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSecretVersionsFixedSizeCollection createEmptyCollection() {
            return new ListSecretVersionsFixedSizeCollection(null, 0);
        }

        protected ListSecretVersionsFixedSizeCollection createCollection(List<ListSecretVersionsPage> pages, int collectionSize) {
            return new ListSecretVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSecretVersionsPage
    extends AbstractPage<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion, ListSecretVersionsPage> {
        private ListSecretVersionsPage(PageContext<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion> context, ListSecretVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSecretVersionsPage createEmptyPage() {
            return new ListSecretVersionsPage(null, null);
        }

        protected ListSecretVersionsPage createPage(PageContext<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion> context, ListSecretVersionsResponse response) {
            return new ListSecretVersionsPage(context, response);
        }

        public ApiFuture<ListSecretVersionsPage> createPageAsync(PageContext<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion> context, ApiFuture<ListSecretVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSecretVersionsPagedResponse
    extends AbstractPagedListResponse<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion, ListSecretVersionsPage, ListSecretVersionsFixedSizeCollection> {
        public static ApiFuture<ListSecretVersionsPagedResponse> createAsync(PageContext<ListSecretVersionsRequest, ListSecretVersionsResponse, SecretVersion> context, ApiFuture<ListSecretVersionsResponse> futureResponse) {
            ApiFuture<ListSecretVersionsPage> futurePage = ListSecretVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSecretVersionsPagedResponse((ListSecretVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSecretVersionsPagedResponse(ListSecretVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSecretVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSecretsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSecretsRequest, ListSecretsResponse, Secret, ListSecretsPage, ListSecretsFixedSizeCollection> {
        private ListSecretsFixedSizeCollection(List<ListSecretsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSecretsFixedSizeCollection createEmptyCollection() {
            return new ListSecretsFixedSizeCollection(null, 0);
        }

        protected ListSecretsFixedSizeCollection createCollection(List<ListSecretsPage> pages, int collectionSize) {
            return new ListSecretsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSecretsPage
    extends AbstractPage<ListSecretsRequest, ListSecretsResponse, Secret, ListSecretsPage> {
        private ListSecretsPage(PageContext<ListSecretsRequest, ListSecretsResponse, Secret> context, ListSecretsResponse response) {
            super(context, (Object)response);
        }

        private static ListSecretsPage createEmptyPage() {
            return new ListSecretsPage(null, null);
        }

        protected ListSecretsPage createPage(PageContext<ListSecretsRequest, ListSecretsResponse, Secret> context, ListSecretsResponse response) {
            return new ListSecretsPage(context, response);
        }

        public ApiFuture<ListSecretsPage> createPageAsync(PageContext<ListSecretsRequest, ListSecretsResponse, Secret> context, ApiFuture<ListSecretsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSecretsPagedResponse
    extends AbstractPagedListResponse<ListSecretsRequest, ListSecretsResponse, Secret, ListSecretsPage, ListSecretsFixedSizeCollection> {
        public static ApiFuture<ListSecretsPagedResponse> createAsync(PageContext<ListSecretsRequest, ListSecretsResponse, Secret> context, ApiFuture<ListSecretsResponse> futureResponse) {
            ApiFuture<ListSecretsPage> futurePage = ListSecretsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSecretsPagedResponse((ListSecretsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSecretsPagedResponse(ListSecretsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSecretsFixedSizeCollection.createEmptyCollection());
        }
    }
}

