/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.GuacamoleSession;
import org.apache.guacamole.GuacamoleUnauthorizedException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Connectable;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.event.TunnelCloseEvent;
import org.apache.guacamole.net.event.TunnelConnectEvent;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.rest.auth.AuthenticationService;
import org.apache.guacamole.rest.auth.DecoratedUserContext;
import org.apache.guacamole.rest.event.ListenerService;
import org.apache.guacamole.tunnel.StandardTokenMap;
import org.apache.guacamole.tunnel.TunnelRequest;
import org.apache.guacamole.tunnel.TunnelRequestService;
import org.apache.guacamole.tunnel.TunnelRequestType;
import org.apache.guacamole.tunnel.UserTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TunnelRequestService {
    private final Logger logger = LoggerFactory.getLogger(TunnelRequestService.class);
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private ListenerService listenerService;

    private void fireTunnelConnectEvent(AuthenticatedUser authenticatedUser, Credentials credentials, GuacamoleTunnel tunnel) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new TunnelConnectEvent(authenticatedUser, credentials, tunnel));
    }

    private void fireTunnelClosedEvent(AuthenticatedUser authenticatedUser, Credentials credentials, GuacamoleTunnel tunnel) throws GuacamoleException {
        this.listenerService.handleEvent((Object)new TunnelCloseEvent(authenticatedUser, credentials, tunnel));
    }

    protected GuacamoleClientInformation getClientInformation(TunnelRequest request) throws GuacamoleException {
        String timezone;
        List imageMimetypes;
        List videoMimetypes;
        List audioMimetypes;
        Integer dpi;
        Integer height;
        GuacamoleClientInformation info = new GuacamoleClientInformation();
        Integer width = request.getWidth();
        if (width != null) {
            info.setOptimalScreenWidth(width.intValue());
        }
        if ((height = request.getHeight()) != null) {
            info.setOptimalScreenHeight(height.intValue());
        }
        if ((dpi = request.getDPI()) != null) {
            info.setOptimalResolution(dpi.intValue());
        }
        if ((audioMimetypes = request.getAudioMimetypes()) != null) {
            info.getAudioMimetypes().addAll(audioMimetypes);
        }
        if ((videoMimetypes = request.getVideoMimetypes()) != null) {
            info.getVideoMimetypes().addAll(videoMimetypes);
        }
        if ((imageMimetypes = request.getImageMimetypes()) != null) {
            info.getImageMimetypes().addAll(imageMimetypes);
        }
        if ((timezone = request.getTimezone()) != null && !timezone.isEmpty()) {
            info.setTimezone(timezone);
        }
        return info;
    }

    protected GuacamoleTunnel createConnectedTunnel(UserContext context, TunnelRequestType type, String id, GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        Connectable connectable = type.getConnectable(context, id);
        if (connectable == null) {
            throw new GuacamoleResourceNotFoundException("Requested tunnel destination does not exist.");
        }
        GuacamoleTunnel tunnel = connectable.connect(info, tokens);
        this.logger.info("User \"{}\" connected to {} \"{}\".", new Object[]{context.self().getIdentifier(), type.NAME, id});
        return tunnel;
    }

    protected GuacamoleTunnel createAssociatedTunnel(GuacamoleTunnel tunnel, String authToken, GuacamoleSession session, UserContext context, TunnelRequestType type, String id) throws GuacamoleException {
        1 monitoredTunnel = new /* Unavailable Anonymous Inner Class!! */;
        session.addTunnel((UserTunnel)monitoredTunnel);
        return monitoredTunnel;
    }

    public GuacamoleTunnel createTunnel(TunnelRequest request) throws GuacamoleException {
        String authToken = request.getAuthenticationToken();
        String id = request.getIdentifier();
        TunnelRequestType type = request.getType();
        String authProviderIdentifier = request.getAuthenticationProviderIdentifier();
        GuacamoleClientInformation info = this.getClientInformation(request);
        GuacamoleSession session = this.authenticationService.getGuacamoleSession(authToken);
        AuthenticatedUser authenticatedUser = session.getAuthenticatedUser();
        DecoratedUserContext userContext = session.getUserContext(authProviderIdentifier);
        String name = authenticatedUser.getIdentifier();
        if (name != null) {
            info.setName(name);
        }
        try {
            GuacamoleTunnel tunnel = this.createConnectedTunnel((UserContext)userContext, type, id, info, (Map)new StandardTokenMap(authenticatedUser));
            this.fireTunnelConnectEvent(authenticatedUser, authenticatedUser.getCredentials(), tunnel);
            return this.createAssociatedTunnel(tunnel, authToken, session, (UserContext)userContext, type, id);
        }
        catch (GuacamoleUnauthorizedException e) {
            if (this.authenticationService.destroyGuacamoleSession(authToken)) {
                this.logger.debug("Implicitly invalidated session for token \"{}\".", (Object)authToken);
            }
            throw e;
        }
    }

    static /* synthetic */ void access$000(TunnelRequestService x0, AuthenticatedUser x1, Credentials x2, GuacamoleTunnel x3) throws GuacamoleException {
        x0.fireTunnelClosedEvent(x1, x2, x3);
    }

    static /* synthetic */ Logger access$100(TunnelRequestService x0) {
        return x0.logger;
    }

    static /* synthetic */ AuthenticationService access$200(TunnelRequestService x0) {
        return x0.authenticationService;
    }
}

