/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.history;

import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.simple.SimpleActivityRecordSet;
import org.apache.guacamole.rest.history.ConnectionHistoryResource;
import org.apache.guacamole.rest.history.UserHistoryResource;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class HistoryResource {
    private final UserContext userContext;

    public HistoryResource(UserContext userContext) {
        this.userContext = userContext;
    }

    @Path(value="connections")
    public ConnectionHistoryResource getConnectionHistory() throws GuacamoleException {
        try {
            return new ConnectionHistoryResource(this.userContext.getConnectionHistory());
        }
        catch (GuacamoleUnsupportedException e) {
            return new ConnectionHistoryResource((ActivityRecordSet)new SimpleActivityRecordSet());
        }
    }

    @Path(value="users")
    public UserHistoryResource getUserHistory() throws GuacamoleException {
        try {
            return new UserHistoryResource(this.userContext.getUserHistory());
        }
        catch (GuacamoleUnsupportedException e) {
            return new UserHistoryResource((ActivityRecordSet)new SimpleActivityRecordSet());
        }
    }
}

