/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.rest.history.APIActivityRecord;
import org.apache.guacamole.rest.history.APISortPredicate;
import org.apache.guacamole.rest.history.ActivityRecordResource;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public abstract class ActivityRecordSetResource<InternalRecordType extends ActivityRecord, ExternalRecordType extends APIActivityRecord> {
    private static final int MAXIMUM_HISTORY_SIZE = 1000;
    private ActivityRecordSet<InternalRecordType> history;

    public ActivityRecordSetResource(ActivityRecordSet<InternalRecordType> history) {
        this.history = history;
    }

    protected abstract ExternalRecordType toExternalRecord(InternalRecordType var1);

    private void applyCriteria(List<String> requiredContents, List<APISortPredicate> sortPredicates) throws GuacamoleException {
        for (String required : requiredContents) {
            if (required.isEmpty()) continue;
            this.history = this.history.contains(required);
        }
        for (APISortPredicate predicate : sortPredicates) {
            this.history = this.history.sort(predicate.getProperty(), predicate.isDescending());
        }
        this.history = this.history.limit(1000);
    }

    @GET
    public List<ExternalRecordType> getRecords(@QueryParam(value="contains") List<String> requiredContents, @QueryParam(value="order") List<APISortPredicate> sortPredicates) throws GuacamoleException {
        this.applyCriteria(requiredContents, sortPredicates);
        ArrayList<APIActivityRecord> apiRecords = new ArrayList<APIActivityRecord>();
        for (ActivityRecord record : this.history.asCollection()) {
            apiRecords.add(this.toExternalRecord(record));
        }
        return apiRecords;
    }

    @Path(value="{identifier}")
    public ActivityRecordResource getRecord(@PathParam(value="identifier") String identifier) throws GuacamoleException {
        ActivityRecord record = this.history.get(identifier);
        if (record == null) {
            throw new GuacamoleResourceNotFoundException("Not found: \"" + identifier + "\"");
        }
        return new ActivityRecordResource(record, this.toExternalRecord(record));
    }
}

