/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.commons.support.ResourceSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.FilePosition;

@API(status=API.Status.STABLE, since="1.0")
public class ClasspathResourceSelector
implements DiscoverySelector {
    private final String classpathResourceName;
    private final FilePosition position;
    private Set<Resource> resources;

    ClasspathResourceSelector(String classpathResourceName, FilePosition position) {
        boolean startsWithSlash = classpathResourceName.startsWith("/");
        this.classpathResourceName = startsWithSlash ? classpathResourceName.substring(1) : classpathResourceName;
        Preconditions.notBlank((String)this.classpathResourceName, (String)"classpath resource name must not be blank after removing leading slash");
        this.position = position;
    }

    ClasspathResourceSelector(Set<? extends Resource> resources) {
        this(resources.iterator().next().getName(), null);
        this.resources = Collections.unmodifiableSet(new LinkedHashSet<Resource>(resources));
    }

    public String getClasspathResourceName() {
        return this.classpathResourceName;
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated
    public Set<org.junit.platform.commons.support.Resource> getClasspathResources() {
        return this.getResources().stream().map(org.junit.platform.commons.support.Resource::of).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @API(status=API.Status.MAINTAINED, since="1.14")
    public Set<Resource> getResources() {
        if (this.resources == null) {
            Try tryToGetResource = ResourceSupport.tryToGetResources((String)this.classpathResourceName);
            Set classpathResources = (Set)tryToGetResource.getOrThrow(cause -> new PreconditionViolationException("Could not load resource(s) with name: " + this.classpathResourceName, (Throwable)cause));
            if (classpathResources.isEmpty()) {
                throw new PreconditionViolationException("Could not find any resource(s) with name: " + this.classpathResourceName);
            }
            this.resources = Collections.unmodifiableSet(classpathResources);
        }
        return this.resources;
    }

    public Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.position);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathResourceSelector that = (ClasspathResourceSelector)o;
        return Objects.equals(this.classpathResourceName, that.classpathResourceName) && Objects.equals(this.position, that.position);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return Objects.hash(this.classpathResourceName, this.position);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("classpathResourceName", (Object)this.classpathResourceName).append("position", (Object)this.position).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        if (this.position == null) {
            return Optional.of(DiscoverySelectorIdentifier.create("resource", this.classpathResourceName));
        }
        return Optional.of(DiscoverySelectorIdentifier.create("resource", String.format("%s?%s", this.classpathResourceName, this.position.toQueryPart())));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "resource";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<ClasspathResourceSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of((ClasspathResourceSelector)StringUtils.splitIntoTwo((char)'?', (String)identifier.getValue()).map(DiscoverySelectors::selectClasspathResource, (resourceName, query) -> {
                FilePosition position = FilePosition.fromQuery(query).orElse(null);
                return DiscoverySelectors.selectClasspathResource(resourceName, position);
            }));
        }
    }
}

