/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.utils;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.parquet.vector.reader.TimestampColumnReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.Preconditions;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.IntStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.LongStatistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.flink.table.store.shaded.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.flink.table.store.shaded.org.apache.parquet.io.api.Binary;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.MessageType;
import org.apache.flink.table.store.shaded.org.apache.parquet.schema.Type;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFormatStatisticsReportUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFormatStatisticsReportUtil.class);

    public static TableStats getTableStatistics(List<Path> files, DataType producedDataType, Configuration hadoopConfig, boolean isUtcTimestamp) {
        try {
            HashMap columnStatisticsMap = new HashMap();
            RowType producedRowType = (RowType)producedDataType.getLogicalType();
            long rowCount = 0L;
            for (Path file : files) {
                rowCount += ParquetFormatStatisticsReportUtil.updateStatistics(hadoopConfig, file, columnStatisticsMap);
            }
            Map<String, ColumnStats> columnStatsMap = ParquetFormatStatisticsReportUtil.convertToColumnStats(columnStatisticsMap, producedRowType, isUtcTimestamp);
            return new TableStats(rowCount, columnStatsMap);
        }
        catch (Exception e) {
            LOG.warn("Reporting statistics failed for Parquet format: {}", (Object)e.getMessage());
            return TableStats.UNKNOWN;
        }
    }

    private static Map<String, ColumnStats> convertToColumnStats(Map<String, Statistics<?>> columnStatisticsMap, RowType producedRowType, boolean isUtcTimestamp) {
        HashMap<String, ColumnStats> columnStatMap = new HashMap<String, ColumnStats>();
        for (String column : producedRowType.getFieldNames()) {
            Statistics<?> statistics = columnStatisticsMap.get(column);
            if (statistics == null) continue;
            ColumnStats columnStats = ParquetFormatStatisticsReportUtil.convertToColumnStats(producedRowType.getTypeAt(producedRowType.getFieldIndex(column)), statistics, isUtcTimestamp);
            columnStatMap.put(column, columnStats);
        }
        return columnStatMap;
    }

    private static ColumnStats convertToColumnStats(LogicalType logicalType, Statistics<?> statistics, boolean isUtcTimestamp) {
        ColumnStats.Builder builder = new ColumnStats.Builder().setNullCount(statistics.getNumNulls());
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: 
            case BINARY: 
            case VARBINARY: {
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (statistics instanceof IntStatistics) {
                    builder.setMin(Integer.valueOf(((IntStatistics)statistics).getMin())).setMax(Integer.valueOf(((IntStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof LongStatistics) {
                    builder.setMin(Long.valueOf(((LongStatistics)statistics).getMin())).setMax(Long.valueOf(((LongStatistics)statistics).getMax()));
                    break;
                }
                return null;
            }
            case DOUBLE: {
                if (statistics instanceof DoubleStatistics) {
                    builder.setMin(Double.valueOf(((DoubleStatistics)statistics).getMin())).setMax(Double.valueOf(((DoubleStatistics)statistics).getMax()));
                    break;
                }
                return null;
            }
            case FLOAT: {
                if (statistics instanceof FloatStatistics) {
                    builder.setMin(Float.valueOf(((FloatStatistics)statistics).getMin())).setMax(Float.valueOf(((FloatStatistics)statistics).getMax()));
                    break;
                }
                return null;
            }
            case DATE: {
                if (statistics instanceof IntStatistics) {
                    Date min = Date.valueOf(DateTimeUtils.formatDate(((IntStatistics)statistics).getMin()));
                    Date max = Date.valueOf(DateTimeUtils.formatDate(((IntStatistics)statistics).getMax()));
                    builder.setMin(min).setMax(max);
                    break;
                }
                return null;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                if (statistics instanceof IntStatistics) {
                    Time min = Time.valueOf(DateTimeUtils.toLocalTime(((IntStatistics)statistics).getMin()));
                    Time max = Time.valueOf(DateTimeUtils.toLocalTime(((IntStatistics)statistics).getMax()));
                    builder.setMin(min).setMax(max);
                    break;
                }
                return null;
            }
            case CHAR: 
            case VARCHAR: {
                if (statistics instanceof BinaryStatistics) {
                    Binary min = ((BinaryStatistics)statistics).genericGetMin();
                    Binary max = ((BinaryStatistics)statistics).genericGetMax();
                    if (min != null) {
                        builder.setMin((Comparable<?>)((Object)min.toStringUsingUTF8()));
                    } else {
                        builder.setMin(null);
                    }
                    if (max != null) {
                        builder.setMax((Comparable<?>)((Object)max.toStringUsingUTF8()));
                        break;
                    }
                    builder.setMax(null);
                    break;
                }
                return null;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                if (statistics instanceof LongStatistics) {
                    builder.setMin(new Timestamp(((LongStatistics)statistics).getMin())).setMax(new Timestamp(((LongStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof BinaryStatistics) {
                    Binary min = ((BinaryStatistics)statistics).genericGetMin();
                    Binary max = ((BinaryStatistics)statistics).genericGetMax();
                    if (min != null) {
                        builder.setMin(ParquetFormatStatisticsReportUtil.binaryToTimestamp(min, isUtcTimestamp));
                    } else {
                        builder.setMin(null);
                    }
                    if (max != null) {
                        builder.setMax(ParquetFormatStatisticsReportUtil.binaryToTimestamp(max, isUtcTimestamp));
                        break;
                    }
                    builder.setMax(null);
                    break;
                }
                return null;
            }
            case DECIMAL: {
                if (statistics instanceof IntStatistics) {
                    builder.setMin(BigDecimal.valueOf(((IntStatistics)statistics).getMin())).setMax(BigDecimal.valueOf(((IntStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof LongStatistics) {
                    builder.setMin(BigDecimal.valueOf(((LongStatistics)statistics).getMin())).setMax(BigDecimal.valueOf(((LongStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof BinaryStatistics) {
                    Binary min = ((BinaryStatistics)statistics).genericGetMin();
                    Binary max = ((BinaryStatistics)statistics).genericGetMax();
                    if (min != null) {
                        builder.setMin(ParquetFormatStatisticsReportUtil.binaryToDecimal(min, ((DecimalType)logicalType).getScale()));
                    } else {
                        builder.setMin(null);
                    }
                    if (max != null) {
                        builder.setMax(ParquetFormatStatisticsReportUtil.binaryToDecimal(max, ((DecimalType)logicalType).getScale()));
                        break;
                    }
                    builder.setMax(null);
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return builder.build();
    }

    private static long updateStatistics(Configuration hadoopConfig, Path file, Map<String, Statistics<?>> columnStatisticsMap) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = new org.apache.hadoop.fs.Path(file.toUri());
        ParquetMetadata metadata = ParquetFileReader.readFooter(hadoopConfig, hadoopPath);
        MessageType schema = metadata.getFileMetaData().getSchema();
        List columns = schema.asGroupType().getFields().stream().map(Type::getName).collect(Collectors.toList());
        List<BlockMetaData> blocks = metadata.getBlocks();
        long rowCount = 0L;
        for (BlockMetaData block : blocks) {
            rowCount += block.getRowCount();
            for (int i = 0; i < columns.size(); ++i) {
                ParquetFormatStatisticsReportUtil.updateStatistics(block.getColumns().get(i).getStatistics(), (String)columns.get(i), columnStatisticsMap);
            }
        }
        return rowCount;
    }

    private static void updateStatistics(Statistics<?> statistics, String column, Map<String, Statistics<?>> columnStatisticsMap) {
        Statistics<?> previousStatistics = columnStatisticsMap.get(column);
        if (previousStatistics == null) {
            columnStatisticsMap.put(column, statistics);
        } else {
            previousStatistics.mergeStatistics(statistics);
        }
    }

    private static BigDecimal binaryToDecimal(Binary decimal, int scale) {
        BigInteger bigInteger = new BigInteger(decimal.getBytesUnsafe());
        return new BigDecimal(bigInteger, scale);
    }

    private static Timestamp binaryToTimestamp(Binary timestamp, boolean utcTimestamp) {
        Preconditions.checkArgument(timestamp.length() == 12, "Must be 12 bytes");
        ByteBuffer buf = timestamp.toByteBuffer();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = buf.getLong();
        int julianDay = buf.getInt();
        TimestampData timestampData = TimestampColumnReader.int96ToTimestamp(utcTimestamp, timeOfDayNanos, julianDay);
        return timestampData.toTimestamp();
    }
}

