/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Database;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.flink.table.store.shaded.org.apache.thrift.TException;
import org.codehaus.jackson.annotate.JsonProperty;

public class JSONAlterDatabaseMessage
extends AlterDatabaseMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String dbObjBeforeJson;
    @JsonProperty
    String dbObjAfterJson;
    @JsonProperty
    Long timestamp;

    public JSONAlterDatabaseMessage() {
    }

    public JSONAlterDatabaseMessage(String server, String servicePrincipal, Database dbObjBefore, Database dbObjAfter, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = dbObjBefore.getName();
        this.timestamp = timestamp;
        try {
            this.dbObjBeforeJson = JSONMessageFactory.createDatabaseObjJson(dbObjBefore);
            this.dbObjAfterJson = JSONMessageFactory.createDatabaseObjJson(dbObjAfter);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.checkValid();
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Database getDbObjBefore() throws Exception {
        return (Database)JSONMessageFactory.getTObj(this.dbObjBeforeJson, Database.class);
    }

    @Override
    public Database getDbObjAfter() throws Exception {
        return (Database)JSONMessageFactory.getTObj(this.dbObjAfterJson, Database.class);
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }
}

