/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact.aggregate;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionFactory;
import org.apache.flink.table.store.file.mergetree.compact.aggregate.FieldAggregator;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class AggregateMergeFunction
implements MergeFunction<KeyValue> {
    private final RowData.FieldGetter[] getters;
    private final RowAggregator rowAggregator;
    private KeyValue latestKv;
    private GenericRowData row;
    private KeyValue reused;

    protected AggregateMergeFunction(RowData.FieldGetter[] getters, RowAggregator rowAggregator) {
        this.getters = getters;
        this.rowAggregator = rowAggregator;
    }

    @Override
    public void reset() {
        this.latestKv = null;
        this.row = new GenericRowData(this.getters.length);
    }

    @Override
    public void add(KeyValue kv) {
        Preconditions.checkArgument((kv.valueKind() == RowKind.INSERT || kv.valueKind() == RowKind.UPDATE_AFTER ? 1 : 0) != 0, (Object)"Pre-aggregate can not accept delete records!");
        this.latestKv = kv;
        for (int i = 0; i < this.getters.length; ++i) {
            FieldAggregator fieldAggregator = this.rowAggregator.getFieldAggregatorAtPos(i);
            Object accumulator = this.getters[i].getFieldOrNull((RowData)this.row);
            Object inputField = this.getters[i].getFieldOrNull(kv.value());
            Object mergedField = fieldAggregator.agg(accumulator, inputField);
            this.row.setField(i, mergedField);
        }
    }

    @Override
    @Nullable
    public KeyValue getResult() {
        Preconditions.checkNotNull((Object)this.latestKv, (String)"Trying to get result from merge function without any input. This is unexpected.");
        if (this.reused == null) {
            this.reused = new KeyValue();
        }
        return this.reused.replace(this.latestKv.key(), this.latestKv.sequenceNumber(), RowKind.INSERT, (RowData)this.row);
    }

    public static MergeFunctionFactory<KeyValue> factory(Configuration conf, List<String> tableNames, List<LogicalType> tableTypes, List<String> primaryKeys) {
        return new Factory(conf, tableNames, tableTypes, primaryKeys);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final Configuration conf;
        private final List<String> tableNames;
        private final List<LogicalType> tableTypes;
        private final List<String> primaryKeys;

        private Factory(Configuration conf, List<String> tableNames, List<LogicalType> tableTypes, List<String> primaryKeys) {
            this.conf = conf;
            this.tableNames = tableNames;
            this.tableTypes = tableTypes;
            this.primaryKeys = primaryKeys;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            List<String> fieldNames = this.tableNames;
            List<LogicalType> fieldTypes = this.tableTypes;
            if (projection != null) {
                Projection project = Projection.of(projection);
                fieldNames = project.project(this.tableNames);
                fieldTypes = project.project(this.tableTypes);
            }
            return new AggregateMergeFunction(RowDataUtils.createFieldGetters(fieldTypes), new RowAggregator(this.conf, fieldNames, fieldTypes, this.primaryKeys));
        }
    }

    public static class RowAggregator
    implements Serializable {
        public static final String FIELDS = "fields";
        public static final String AGG_FUNCTION = "aggregate-function";
        private final FieldAggregator[] fieldAggregators;

        public RowAggregator(Configuration sqlConf, List<String> fieldNames, List<LogicalType> fieldTypes, List<String> primaryKeys) {
            this.fieldAggregators = new FieldAggregator[fieldNames.size()];
            for (int i = 0; i < fieldNames.size(); ++i) {
                String fieldName = fieldNames.get(i);
                LogicalType fieldType = fieldTypes.get(i);
                boolean isPrimaryKey = primaryKeys.contains(fieldName);
                String strAggFunc = sqlConf.getString(ConfigOptions.key((String)("fields." + fieldName + "." + AGG_FUNCTION)).stringType().noDefaultValue().withDescription("Get " + fieldName + "'s aggregate function"));
                this.fieldAggregators[i] = FieldAggregator.createFieldAggregator(fieldType, strAggFunc, isPrimaryKey);
            }
        }

        public FieldAggregator getFieldAggregatorAtPos(int fieldPos) {
            return this.fieldAggregators[fieldPos];
        }
    }
}

