/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file;

import java.util.Comparator;
import java.util.function.Supplier;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.AbstractFileStore;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.table.store.file.operation.KeyValueFileStoreRead;
import org.apache.flink.table.store.file.operation.KeyValueFileStoreScan;
import org.apache.flink.table.store.file.operation.KeyValueFileStoreWrite;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.utils.KeyComparatorSupplier;
import org.apache.flink.table.types.logical.RowType;

public class KeyValueFileStore
extends AbstractFileStore<KeyValue> {
    private static final long serialVersionUID = 1L;
    private final RowType bucketKeyType;
    private final RowType keyType;
    private final RowType valueType;
    private final Supplier<Comparator<RowData>> keyComparatorSupplier;
    private final MergeFunction mergeFunction;

    public KeyValueFileStore(SchemaManager schemaManager, long schemaId, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType keyType, RowType valueType, MergeFunction mergeFunction) {
        super(schemaManager, schemaId, options, partitionType);
        this.bucketKeyType = bucketKeyType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.mergeFunction = mergeFunction;
        this.keyComparatorSupplier = new KeyComparatorSupplier(keyType);
    }

    @Override
    public KeyValueFileStoreScan newScan() {
        return this.newScan(false);
    }

    public KeyValueFileStoreRead newRead() {
        return new KeyValueFileStoreRead(this.schemaManager, this.schemaId, this.keyType, this.valueType, this.newKeyComparator(), this.mergeFunction, this.options.fileFormat(), this.pathFactory());
    }

    public KeyValueFileStoreWrite newWrite() {
        return new KeyValueFileStoreWrite(this.schemaManager, this.schemaId, this.keyType, this.valueType, this.keyComparatorSupplier, this.mergeFunction, this.pathFactory(), this.snapshotManager(), this.newScan(true), this.options);
    }

    private KeyValueFileStoreScan newScan(boolean checkNumOfBuckets) {
        return new KeyValueFileStoreScan(this.partitionType, this.bucketKeyType, this.keyType, this.snapshotManager(), this.manifestFileFactory(), this.manifestListFactory(), this.options.bucket(), checkNumOfBuckets);
    }

    @Override
    public Comparator<RowData> newKeyComparator() {
        return this.keyComparatorSupplier.get();
    }
}

