/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import org.apache.flink.runtime.memory.MemoryReservationException;

class UnsafeMemoryBudget {
    private final long totalMemorySize;
    private final AtomicLong availableMemorySize;

    UnsafeMemoryBudget(long totalMemorySize) {
        this.totalMemorySize = totalMemorySize;
        this.availableMemorySize = new AtomicLong(totalMemorySize);
    }

    long getTotalMemorySize() {
        return this.totalMemorySize;
    }

    long getAvailableMemorySize() {
        return this.availableMemorySize.get();
    }

    boolean verifyEmpty() {
        try {
            this.reserveMemory(this.totalMemorySize);
        }
        catch (MemoryReservationException e) {
            return false;
        }
        this.releaseMemory(this.totalMemorySize);
        return this.availableMemorySize.get() == this.totalMemorySize;
    }

    void reserveMemory(long size) throws MemoryReservationException {
        long availableOrReserved = this.tryReserveMemory(size);
        if (availableOrReserved >= size) {
            return;
        }
        throw new MemoryReservationException(String.format("Could not allocate %d bytes, only %d bytes are remaining. This usually indicates that you are requesting more memory than you have reserved. However, when running an old JVM version it can also be caused by slow garbage collection. Try to upgrade to Java 8u72 or higher if running on an old Java version.", size, availableOrReserved));
    }

    private long tryReserveMemory(long size) {
        long currentAvailableMemorySize;
        while (size <= (currentAvailableMemorySize = this.availableMemorySize.get())) {
            if (!this.availableMemorySize.compareAndSet(currentAvailableMemorySize, currentAvailableMemorySize - size)) continue;
            return size;
        }
        return currentAvailableMemorySize;
    }

    void releaseMemory(@Nonnegative long size) {
        if (size == 0L) {
            return;
        }
        boolean released = false;
        long currentAvailableMemorySize = 0L;
        while (!released && this.totalMemorySize >= (currentAvailableMemorySize = this.availableMemorySize.get()) + size) {
            released = this.availableMemorySize.compareAndSet(currentAvailableMemorySize, currentAvailableMemorySize + size);
        }
        if (!released) {
            throw new IllegalStateException(String.format("Trying to release more managed memory (%d bytes) than has been allocated (%d bytes), the total size is %d bytes", size, currentAvailableMemorySize, this.totalMemorySize));
        }
    }
}

