/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class IntMap {
    private int[] keys;
    private Object[] values;
    private int size;

    public IntMap() {
        this(10);
    }

    public IntMap(int n) {
        this.keys = new int[n];
        this.values = new Object[n];
    }

    public int capacity() {
        return this.keys.length;
    }

    private int find(int n) {
        int n2 = 0;
        int n3 = this.size - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.keys[n4];
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public Object remove(int n) {
        Object object = null;
        int n2 = this.find(n);
        if (n2 >= 0) {
            object = this.values[n2];
            System.arraycopy(this.keys, n2 + 1, this.keys, n2, this.size - n2 - 1);
            System.arraycopy(this.values, n2 + 1, this.values, n2, this.size - n2 - 1);
            --this.size;
        }
        return object;
    }

    public void clear() {
        this.size = 0;
    }

    public Object put(int n, Object object) {
        if (this.size == 0 || n > this.keys[this.size - 1]) {
            if (this.size == this.keys.length) {
                this.grow();
            }
            this.keys[this.size] = n;
            this.values[this.size] = object;
            ++this.size;
            return null;
        }
        int n2 = this.find(n);
        if (n2 >= 0) {
            Object object2 = this.values[n2];
            this.values[n2] = object;
            return object2;
        }
        n2 = -n2 - 1;
        if (this.size == this.keys.length) {
            this.grow();
        }
        System.arraycopy(this.keys, n2, this.keys, n2 + 1, this.size - n2);
        System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
        this.keys[n2] = n;
        this.values[n2] = object;
        ++this.size;
        return null;
    }

    private void grow() {
        int[] nArray = new int[this.size * 2];
        System.arraycopy(this.keys, 0, nArray, 0, this.size);
        this.keys = nArray;
        Object[] objectArray = new Object[this.size * 2];
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        this.values = objectArray;
    }

    public Object get(int n) {
        int n2 = this.find(n);
        return n2 >= 0 ? this.values[n2] : null;
    }

    public boolean contains(int n) {
        return this.find(n) >= 0;
    }

    public Object getNextAdjacent(int n) {
        int n2 = this.find(n);
        return n2 >= 0 && n2 + 1 < this.size ? this.values[n2 + 1] : null;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < IntMap.this.size;
            }

            public Object next() {
                if (this.i >= IntMap.this.size) {
                    throw new NoSuchElementException();
                }
                final int n = this.i++;
                return new Map.Entry(){

                    public Object getKey() {
                        return new Integer(IntMap.this.keys[n]);
                    }

                    public Object getValue() {
                        return IntMap.this.values[n];
                    }

                    public Object setValue(Object object) {
                        Object object2 = IntMap.this.values[n];
                        ((IntMap)IntMap.this).values[n] = object;
                        return object2;
                    }
                };
            }

            @Override
            public void remove() {
                System.arraycopy(IntMap.this.keys, this.i, IntMap.this.keys, this.i - 1, IntMap.this.size - this.i);
                System.arraycopy(IntMap.this.values, this.i, IntMap.this.values, this.i - 1, IntMap.this.size - this.i);
                IntMap.this.size--;
            }
        };
    }

    public int size() {
        return this.size;
    }

    public Object[] valuesToArray(Object[] objectArray) {
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public int[] keySetToArray() {
        int[] nArray = new int[this.size()];
        System.arraycopy(this.keys, 0, nArray, 0, this.size);
        return nArray;
    }
}

