/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swf.types;

import org.apache.flex.swf.tags.CharacterIterableFactory;
import org.apache.flex.swf.tags.ICharacterReferrer;
import org.apache.flex.swf.tags.ICharacterTag;
import org.apache.flex.swf.types.IFillStyle;
import org.apache.flex.swf.types.ILineStyle;
import org.apache.flex.swf.types.ShapeRecord;
import org.apache.flex.swf.types.Styles;

public class StyleChangeRecord
extends ShapeRecord
implements ICharacterReferrer {
    private boolean stateNewStyles = false;
    private boolean stateLineStyle = false;
    private boolean stateFillStyle1 = false;
    private boolean stateFillStyle0 = false;
    private boolean stateMoveTo = false;
    private int moveDeltaX;
    private int moveDeltaY;
    private IFillStyle fillStyle0;
    private IFillStyle fillStyle1;
    private ILineStyle lineStyle;
    private int numFillBits;
    private int numLineBits;
    private Styles styles;

    public StyleChangeRecord() {
        super(ShapeRecord.ShapeRecordType.STYLE_CHANGE);
    }

    public void setMove(int x, int y) {
        this.stateMoveTo = true;
        this.moveDeltaX = x;
        this.moveDeltaY = y;
    }

    public void setDefinedStyles(IFillStyle fillStyle0, IFillStyle fillStyle1, ILineStyle lineStyle, Styles styleContext) {
        if (fillStyle0 != null && !styleContext.getFillStyles().contains(fillStyle0)) {
            throw new IllegalArgumentException("FillStyle0 is not defined in parent shape.");
        }
        if (fillStyle1 != null && !styleContext.getFillStyles().contains(fillStyle1)) {
            throw new IllegalArgumentException("FillStyle1 is not defined in parent shape.");
        }
        if (lineStyle != null && !styleContext.getLineStyles().contains(lineStyle)) {
            throw new IllegalArgumentException("LineStyle is not defined in parent shape.");
        }
        this.fillStyle0 = fillStyle0;
        this.fillStyle1 = fillStyle1;
        this.lineStyle = lineStyle;
        this.stateFillStyle0 = fillStyle0 != null;
        this.stateFillStyle1 = fillStyle1 != null;
        this.stateLineStyle = lineStyle != null;
    }

    public void setDefinedStyles(IFillStyle fillStyle0, IFillStyle fillStyle1, ILineStyle lineStyle, boolean stateFillStyle0, boolean stateFillStyle1, boolean stateLineStyle, Styles styleContext) {
        this.fillStyle0 = fillStyle0;
        this.fillStyle1 = fillStyle1;
        this.lineStyle = lineStyle;
        this.stateFillStyle0 = stateFillStyle0;
        this.stateFillStyle1 = stateFillStyle1;
        this.stateLineStyle = stateLineStyle;
    }

    public void setDefinedStyles(int fillStyle0Index, int fillStyle1Index, int lineStyleIndex, Styles styleContext) {
        if (fillStyle0Index >= 0) {
            this.fillStyle0 = fillStyle0Index > 0 ? (IFillStyle)styleContext.getFillStyles().get(fillStyle0Index - 1) : null;
            this.stateFillStyle0 = true;
        }
        if (fillStyle1Index >= 0) {
            this.fillStyle1 = fillStyle1Index > 0 ? (IFillStyle)styleContext.getFillStyles().get(fillStyle1Index - 1) : null;
            this.stateFillStyle1 = true;
        }
        if (lineStyleIndex >= 0) {
            this.lineStyle = lineStyleIndex > 0 ? (ILineStyle)styleContext.getLineStyles().get(lineStyleIndex - 1) : null;
            this.stateLineStyle = true;
        }
    }

    public void setDefinedFontStyles(int fillStyle0Index, int fillStyle1Index, int lineStyleIndex, Styles styleContext) {
        if (fillStyle0Index >= 0) {
            this.fillStyle0 = null;
            this.stateFillStyle0 = true;
        }
        if (fillStyle1Index >= 0) {
            this.fillStyle1 = null;
            this.stateFillStyle1 = true;
        }
        if (lineStyleIndex >= 0) {
            this.lineStyle = null;
            this.stateLineStyle = true;
        }
    }

    public void defaultStyles(boolean fill0, boolean fill1, boolean line) {
        if (fill0) {
            this.fillStyle0 = null;
            this.stateFillStyle0 = true;
        }
        if (fill1) {
            this.fillStyle1 = null;
            this.stateFillStyle1 = true;
        }
        if (line) {
            this.lineStyle = null;
            this.stateLineStyle = true;
        }
    }

    public void setNewStyles(Styles value) {
        this.stateNewStyles = true;
        this.styles = value;
    }

    public boolean isStateNewStyles() {
        return this.stateNewStyles;
    }

    public boolean isStateLineStyle() {
        return this.stateLineStyle;
    }

    public boolean isStateFillStyle1() {
        return this.stateFillStyle1;
    }

    public boolean isStateFillStyle0() {
        return this.stateFillStyle0;
    }

    public boolean isStateMoveTo() {
        return this.stateMoveTo;
    }

    public int getMoveDeltaX() {
        return this.moveDeltaX;
    }

    public int getMoveDeltaY() {
        return this.moveDeltaY;
    }

    public IFillStyle getFillstyle0() {
        return this.fillStyle0;
    }

    public IFillStyle getFillstyle1() {
        return this.fillStyle1;
    }

    public ILineStyle getLinestyle() {
        return this.lineStyle;
    }

    public Styles getStyles() {
        return this.styles;
    }

    @Override
    public Iterable<ICharacterTag> getReferences() {
        return CharacterIterableFactory.collect(this.stateFillStyle0 && this.fillStyle0 != null ? this.fillStyle0.getReferences() : CharacterIterableFactory.empty(), this.stateFillStyle1 && this.fillStyle1 != null ? this.fillStyle1.getReferences() : CharacterIterableFactory.empty());
    }

    public int getNumFillBits() {
        return this.numFillBits;
    }

    public void setNumFillBits(int value) {
        this.numFillBits = value;
    }

    public int getNumLineBits() {
        return this.numLineBits;
    }

    public void setNumLineBits(int value) {
        this.numLineBits = value;
    }
}

