/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swc.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.DigestOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCFileEntry;
import org.apache.flex.swc.ISWCLibrary;
import org.apache.flex.swc.io.SWCWriterBase;
import org.apache.flex.swf.ISWF;
import org.apache.flex.swf.io.ISWFWriter;
import org.apache.flex.swf.io.ISWFWriterFactory;
import org.apache.flex.swf.io.SizeReportWritingSWFWriter;

public class SWCWriter
extends SWCWriterBase {
    private final ZipOutputStream zipOutputStream;

    public SWCWriter(String filename) throws FileNotFoundException {
        this(filename, true, true, false, SizeReportWritingSWFWriter.getSWFWriterFactory(null));
    }

    public SWCWriter(String filename, boolean compressLibrarySWF, boolean enableDebug, boolean enableTelemetry, ISWFWriterFactory swfWriterFactory) throws FileNotFoundException {
        super(compressLibrarySWF, enableDebug, enableTelemetry, swfWriterFactory);
        File outputFile = new File(filename);
        File outputDirectory = new File(outputFile.getAbsoluteFile().getParent());
        outputDirectory.mkdirs();
        this.zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.zipOutputStream.setLevel(0);
    }

    @Override
    void writeCatalog(ISWC swc) throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry("catalog.xml"));
        OutputStreamWriter catalogXMLWriter = new OutputStreamWriter(this.zipOutputStream);
        this.writeCatalogXML(swc, catalogXMLWriter);
        ((Writer)catalogXMLWriter).flush();
        this.zipOutputStream.closeEntry();
    }

    @Override
    void writeLibrary(ISWCLibrary library) throws IOException {
        ISWF swf = library.getSWF();
        String path = library.getPath();
        assert (swf != null) : "Expect SWF model";
        assert (path != null) : "Expect SWF path";
        this.zipOutputStream.putNextEntry(new ZipEntry(path));
        DigestOutputStream digestStream = this.getDigestOutputStream(library, this.zipOutputStream);
        ISWFWriter swfWriter = this.swfWriterFactory.createSWFWriter(swf, this.getLibrarySWFCompression(), this.enableDebug, this.enableTelemetry);
        swfWriter.writeTo(digestStream != null ? digestStream : this.zipOutputStream);
        swfWriter.close();
        this.zipOutputStream.closeEntry();
        if (digestStream != null) {
            this.addDigestToLibrary(digestStream, library);
        }
    }

    @Override
    void writeFile(ISWCFileEntry fileEntry) throws IOException {
        this.zipOutputStream.putNextEntry(new ZipEntry(fileEntry.getPath()));
        InputStream fileInputStream = fileEntry.createInputStream();
        IOUtils.copy((InputStream)fileInputStream, (OutputStream)this.zipOutputStream);
        fileInputStream.close();
        this.zipOutputStream.closeEntry();
    }

    @Override
    void prepare(ISWC swc) {
    }

    @Override
    void finish(ISWC swc) throws IOException {
        this.zipOutputStream.flush();
        this.zipOutputStream.close();
    }
}

