/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.swc.catalog;

import com.google.common.collect.Iterables;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.flex.compiler.common.DependencyType;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.ISWCComponent;
import org.apache.flex.swc.ISWCDigest;
import org.apache.flex.swc.ISWCFileEntry;
import org.apache.flex.swc.ISWCLibrary;
import org.apache.flex.swc.ISWCScript;
import org.apache.flex.swc.ISWCVersion;
import org.apache.flex.swc.catalog.ICatalogXMLConstants;
import org.apache.flex.swc.catalog.XMLFormatter;

public class StAXCatalogWriter
implements ICatalogXMLConstants {
    private final XMLStreamWriter xmlWriter;
    private final ISWC swc;
    private static final Comparator<ISWCComponent> COMPONENT_COMPARATOR = new Comparator<ISWCComponent>(){

        @Override
        public int compare(ISWCComponent o1, ISWCComponent o2) {
            return o1.getQName().compareTo(o2.getQName());
        }
    };
    private static final Comparator<ISWCFileEntry> FILE_COMPARATOR = new Comparator<ISWCFileEntry>(){

        @Override
        public int compare(ISWCFileEntry o1, ISWCFileEntry o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private static final Comparator<ISWCLibrary> LIBRARY_COMPARATOR = new Comparator<ISWCLibrary>(){

        @Override
        public int compare(ISWCLibrary o1, ISWCLibrary o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private static final Comparator<ISWCScript> SCRIPT_COMPARATOR = new Comparator<ISWCScript>(){

        @Override
        public int compare(ISWCScript o1, ISWCScript o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<ISWCDigest> DIGEST_COMPARATOR = new Comparator<ISWCDigest>(){

        @Override
        public int compare(ISWCDigest o1, ISWCDigest o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    };
    private static final Comparator<Map.Entry<String, DependencyType>> DEPENDENCY_MAP_ENTRY_COMPARATOR = new Comparator<Map.Entry<String, DependencyType>>(){

        @Override
        public int compare(Map.Entry<String, DependencyType> arg0, Map.Entry<String, DependencyType> arg1) {
            int result = arg0.getKey().compareTo(arg1.getKey());
            if (result != 0) {
                return result;
            }
            return arg0.getValue().ordinal() - arg1.getValue().ordinal();
        }
    };

    public StAXCatalogWriter(ISWC swc, Writer writer) throws XMLStreamException, FactoryConfigurationError {
        assert (swc != null) : "expect SWC model";
        assert (writer != null) : "expect Writer";
        this.swc = swc;
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        assert (xmlOutputFactory != null) : "Expect XMLOutputFactory implementation.";
        this.xmlWriter = new XMLFormatter(xmlOutputFactory.createXMLStreamWriter(writer));
    }

    public void write() throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
        this.xmlWriter.writeStartElement("swc");
        this.xmlWriter.writeAttribute("xmlns", "http://www.adobe.com/flash/swccatalog/9");
        this.writeVersions();
        this.writeFeatures();
        this.writeComponents();
        this.writeLibraries();
        this.writeFiles();
        this.xmlWriter.writeEndElement();
        this.xmlWriter.writeEndDocument();
        this.xmlWriter.flush();
        this.xmlWriter.close();
    }

    private void writeComponents() throws XMLStreamException {
        List<ISWCComponent> componentsList = this.swc.getComponents();
        if (componentsList.isEmpty()) {
            return;
        }
        this.xmlWriter.writeStartElement("components");
        ISWCComponent[] components = componentsList.toArray(new ISWCComponent[componentsList.size()]);
        Arrays.sort(components, COMPONENT_COMPARATOR);
        for (ISWCComponent component : components) {
            this.xmlWriter.writeEmptyElement("component");
            if (component.getQName() != null) {
                this.xmlWriter.writeAttribute("className", StAXCatalogWriter.dottedQNameToColonQName(component.getQName()));
            }
            if (component.getName() != null) {
                this.xmlWriter.writeAttribute("name", component.getName());
            }
            if (component.getURI() != null) {
                this.xmlWriter.writeAttribute("uri", component.getURI());
            }
            if (component.getIcon() != null) {
                this.xmlWriter.writeAttribute("icon", component.getIcon());
            }
            if (component.getPreview() == null) continue;
            this.xmlWriter.writeAttribute("preview", component.getPreview());
        }
        this.xmlWriter.writeEndElement();
    }

    private void writeFiles() throws XMLStreamException {
        Collection<ISWCFileEntry> filesCollection = this.swc.getFiles().values();
        if (filesCollection.isEmpty()) {
            return;
        }
        this.xmlWriter.writeStartElement("files");
        ISWCFileEntry[] files = filesCollection.toArray(new ISWCFileEntry[filesCollection.size()]);
        Arrays.sort(files, FILE_COMPARATOR);
        for (ISWCFileEntry file : files) {
            this.xmlWriter.writeEmptyElement("file");
            this.xmlWriter.writeAttribute("path", file.getPath());
            this.xmlWriter.writeAttribute("mod", String.valueOf(file.getLastModified()));
        }
        this.xmlWriter.writeEndElement();
    }

    private void writeLibraries() throws XMLStreamException {
        this.xmlWriter.writeStartElement("libraries");
        Collection<ISWCLibrary> librariesCollection = this.swc.getLibraries();
        ISWCLibrary[] libraries = librariesCollection.toArray(new ISWCLibrary[librariesCollection.size()]);
        Arrays.sort(libraries, LIBRARY_COMPARATOR);
        for (ISWCLibrary library : libraries) {
            this.xmlWriter.writeStartElement("library");
            this.xmlWriter.writeAttribute("path", library.getPath());
            List<ISWCScript> scriptsList = library.getScripts();
            ISWCScript[] scripts = scriptsList.toArray(new ISWCScript[scriptsList.size()]);
            Arrays.sort(scripts, SCRIPT_COMPARATOR);
            for (ISWCScript script : scripts) {
                this.writeLibraryScript(script);
            }
            Set<String> keepAS3MetadataList = library.getKeepAS3MetadataSet();
            if (!keepAS3MetadataList.isEmpty()) {
                this.xmlWriter.writeStartElement("keep-as3-metadata");
                Object[] keepAS3Metadata = keepAS3MetadataList.toArray(new String[keepAS3MetadataList.size()]);
                Arrays.sort(keepAS3Metadata);
                for (Object metadata : keepAS3Metadata) {
                    this.xmlWriter.writeEmptyElement("metadata");
                    this.xmlWriter.writeAttribute("name", (String)metadata);
                }
                this.xmlWriter.writeEndElement();
            }
            this.xmlWriter.writeStartElement("digests");
            List<ISWCDigest> digestsList = library.getDigests();
            ISWCDigest[] digests = digestsList.toArray(new ISWCDigest[digestsList.size()]);
            Arrays.sort(digests, DIGEST_COMPARATOR);
            for (ISWCDigest digest : digests) {
                this.xmlWriter.writeEmptyElement("digest");
                this.xmlWriter.writeAttribute("type", digest.getType());
                this.xmlWriter.writeAttribute("signed", digest.isSigned() ? "true" : "false");
                this.xmlWriter.writeAttribute("value", digest.getValue());
            }
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndElement();
        }
        this.xmlWriter.writeEndElement();
    }

    private static String dottedQNameToColonQName(String qname) {
        int lastDotIndex = qname.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return qname;
        }
        String packageName = qname.substring(0, lastDotIndex);
        String baseName = qname.substring(lastDotIndex + 1);
        return packageName + ":" + baseName;
    }

    private void writeLibraryScript(ISWCScript script) throws XMLStreamException {
        this.xmlWriter.writeStartElement("script");
        this.xmlWriter.writeAttribute("name", script.getName());
        this.xmlWriter.writeAttribute("mod", String.valueOf(script.getLastModified()));
        if (script.getSignatureChecksum() != null) {
            this.xmlWriter.writeAttribute("signatureChecksum", script.getSignatureChecksum());
        }
        Set<String> definitionsSet = script.getDefinitions();
        Object[] definitions = definitionsSet.toArray(new String[definitionsSet.size()]);
        Arrays.sort(definitions);
        for (Object def : definitions) {
            this.xmlWriter.writeEmptyElement("def");
            this.xmlWriter.writeAttribute("id", StAXCatalogWriter.dottedQNameToColonQName((String)def));
        }
        Set dependenciesSet = script.getDependencies().entries();
        ArrayList dependencies = new ArrayList(dependenciesSet.size());
        Iterables.addAll(dependencies, (Iterable)dependenciesSet);
        Collections.sort(dependencies, DEPENDENCY_MAP_ENTRY_COMPARATOR);
        for (Map.Entry dep : dependencies) {
            this.xmlWriter.writeEmptyElement("dep");
            this.xmlWriter.writeAttribute("id", StAXCatalogWriter.dottedQNameToColonQName((String)dep.getKey()));
            this.xmlWriter.writeAttribute("type", String.valueOf(((DependencyType)((Object)dep.getValue())).getSymbol()));
        }
        this.xmlWriter.writeEndElement();
    }

    private void writeFeatures() throws XMLStreamException {
        this.xmlWriter.writeStartElement("features");
        this.xmlWriter.writeEmptyElement("feature-script-deps");
        if (!this.swc.getComponents().isEmpty()) {
            this.xmlWriter.writeEmptyElement("feature-components");
        }
        if (!this.swc.getFiles().isEmpty()) {
            this.xmlWriter.writeEmptyElement("feature-files");
        }
        this.xmlWriter.writeEndElement();
    }

    private void writeVersions() throws XMLStreamException {
        String compilerVersion;
        String flexVersion;
        ISWCVersion version = this.swc.getVersion();
        if (version == null) {
            return;
        }
        this.xmlWriter.writeStartElement("versions");
        String swcVersion = version.getSWCVersion();
        if (swcVersion != null) {
            this.xmlWriter.writeEmptyElement("swc");
            this.xmlWriter.writeAttribute("version", swcVersion);
        }
        if ((flexVersion = version.getFlexVersion()) != null) {
            String flexMinSupportedVersion;
            this.xmlWriter.writeEmptyElement("flex");
            this.xmlWriter.writeAttribute("version", flexVersion);
            String flexBuild = version.getFlexBuild();
            if (flexBuild != null) {
                this.xmlWriter.writeAttribute("build", flexBuild);
            }
            if ((flexMinSupportedVersion = version.getFlexMinSupportedVersion()) != null) {
                this.xmlWriter.writeAttribute("minimumSupportedVersion", flexMinSupportedVersion);
            }
        }
        if ((compilerVersion = version.getCompilerVersion()) != null) {
            this.xmlWriter.writeEmptyElement("compiler");
            String compilerName = version.getCompilerName();
            if (compilerName != null) {
                this.xmlWriter.writeAttribute("name", compilerName);
            }
            this.xmlWriter.writeAttribute("version", compilerVersion);
            String compilerBuild = version.getCompilerBuild();
            if (compilerBuild != null) {
                this.xmlWriter.writeAttribute("build", compilerBuild);
            }
        }
        this.xmlWriter.writeEndElement();
    }
}

