/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.fxg.dom;

import java.util.Collection;
import java.util.List;
import org.apache.flex.compiler.internal.fxg.dom.AbstractShapeNode;
import org.apache.flex.compiler.internal.fxg.dom.strokes.AbstractStrokeNode;
import org.apache.flex.compiler.internal.fxg.dom.types.Winding;
import org.apache.flex.compiler.internal.fxg.swf.ShapeHelper;
import org.apache.flex.compiler.problems.FXGUnknownAttributeValueProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.swf.types.LineStyle;
import org.apache.flex.swf.types.Rect;
import org.apache.flex.swf.types.ShapeRecord;

public class PathNode
extends AbstractShapeNode {
    public Winding winding = Winding.EVEN_ODD;
    public String data = "";

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("winding".equals(name)) {
            this.winding = this.getWinding(value, problems);
        } else if ("data".equals(name)) {
            this.data = value;
        } else {
            super.setAttribute(name, value, problems);
        }
    }

    @Override
    public String getNodeName() {
        return "Path";
    }

    protected Winding getWinding(String value, Collection<ICompilerProblem> problems) {
        if ("evenOdd".equals(value)) {
            return Winding.EVEN_ODD;
        }
        if ("nonZero".equals(value)) {
            return Winding.NON_ZERO;
        }
        problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "winding", value));
        return this.winding;
    }

    @Override
    public Rect getBounds(List<ShapeRecord> records, LineStyle ls) {
        return ShapeHelper.getBounds(records, ls, (AbstractStrokeNode)this.stroke);
    }
}

