/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.embedding.transcoders;

import java.util.Collection;
import java.util.List;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.internal.embedding.EmbedAttribute;
import org.apache.flex.compiler.internal.embedding.EmbedData;
import org.apache.flex.compiler.internal.embedding.transcoders.TranscoderBase;
import org.apache.flex.compiler.internal.workspaces.Workspace;
import org.apache.flex.compiler.problems.EmbedScalingGridProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.swf.tags.DefineScalingGridTag;
import org.apache.flex.swf.tags.DefineSpriteTag;
import org.apache.flex.swf.tags.ITag;
import org.apache.flex.swf.types.Rect;

public abstract class ScalableTranscoder
extends TranscoderBase {
    protected boolean scaling = false;
    protected Integer scaleGridBottom;
    protected Integer scaleGridLeft;
    protected Integer scaleGridRight;
    protected Integer scaleGridTop;

    protected ScalableTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case SCALE_GRID_BOTTOM: {
                this.scaleGridBottom = (Integer)this.data.getAttribute(EmbedAttribute.SCALE_GRID_BOTTOM);
                break;
            }
            case SCALE_GRID_LEFT: {
                this.scaleGridLeft = (Integer)this.data.getAttribute(EmbedAttribute.SCALE_GRID_LEFT);
                break;
            }
            case SCALE_GRID_RIGHT: {
                this.scaleGridRight = (Integer)this.data.getAttribute(EmbedAttribute.SCALE_GRID_RIGHT);
                break;
            }
            case SCALE_GRID_TOP: {
                this.scaleGridTop = (Integer)this.data.getAttribute(EmbedAttribute.SCALE_GRID_TOP);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected boolean checkAttributeValues(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.checkAttributeValues(location, problems);
        if (!result) {
            return false;
        }
        if (this.scaleGridBottom != null || this.scaleGridLeft != null || this.scaleGridRight != null || this.scaleGridTop != null) {
            if (this.scaleGridBottom == null || this.scaleGridLeft == null || this.scaleGridRight == null || this.scaleGridTop == null) {
                problems.add(new EmbedScalingGridProblem(location));
                result = false;
            } else {
                this.scaling = true;
            }
        }
        return result;
    }

    protected DefineScalingGridTag buildScalingGrid() {
        Rect rect = new Rect(this.scaleGridLeft, this.scaleGridRight, this.scaleGridTop, this.scaleGridBottom);
        DefineScalingGridTag scalingGrid = new DefineScalingGridTag();
        scalingGrid.setSplitter(rect);
        return scalingGrid;
    }

    protected DefineSpriteTag buildSprite(List<ITag> spriteTags, int frameCount, DefineScalingGridTag scalingGrid, Collection<ITag> tags) {
        DefineSpriteTag sprite = new DefineSpriteTag(frameCount, spriteTags);
        if (scalingGrid != null) {
            scalingGrid.setCharacter(sprite);
            tags.add(scalingGrid);
        }
        return sprite;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ScalableTranscoder)) {
            return false;
        }
        ScalableTranscoder t = (ScalableTranscoder)o;
        if (this.scaling != t.scaling) {
            return false;
        }
        return !this.scaling || this.scaleGridBottom.equals(t.scaleGridBottom) && this.scaleGridLeft.equals(t.scaleGridLeft) && this.scaleGridRight.equals(t.scaleGridRight) && this.scaleGridTop.equals(t.scaleGridTop);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode += this.scaling ? 1 : 0;
        if (this.scaleGridBottom != null) {
            hashCode ^= this.scaleGridBottom.hashCode();
        }
        if (this.scaleGridLeft != null) {
            hashCode ^= this.scaleGridLeft.hashCode();
        }
        if (this.scaleGridRight != null) {
            hashCode ^= this.scaleGridRight.hashCode();
        }
        if (this.scaleGridTop != null) {
            hashCode ^= this.scaleGridTop.hashCode();
        }
        return hashCode;
    }
}

